/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.codegen.core;

import com.google.common.io.Files;
import com.mysema.codegen.CodeWriter;
import com.mysema.codegen.JavaWriter;
import com.mysema.codegen.ScalaWriter;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.SimpleType;
import com.mysema.codegen.model.Type;
import com.mysema.codegen.model.TypeCategory;
import com.querydsl.codegen.AbstractModule;
import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;
import com.querydsl.codegen.SimpleSerializerConfig;
import com.querydsl.codegen.TypeMappings;
import com.querydsl.sql.ColumnImpl;
import com.querydsl.sql.ColumnMetadata;
import com.querydsl.sql.Configuration;
import com.querydsl.sql.codegen.KeyDataFactory;
import com.querydsl.sql.codegen.NamingStrategy;
import com.querydsl.sql.codegen.SQLCodegenModule;
import com.querydsl.sql.codegen.SpatialSupport;
import com.querydsl.sql.codegen.support.ForeignKeyData;
import com.querydsl.sql.codegen.support.InverseForeignKeyData;
import com.querydsl.sql.codegen.support.NotNullImpl;
import com.querydsl.sql.codegen.support.PrimaryKeyData;
import com.querydsl.sql.codegen.support.SizeImpl;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.nio.charset.Charset;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.apexes.codegen.core.EntityModel;
import net.apexes.codegen.core.OrmliteEntityBeanSerializer;
import net.apexes.codegen.core.SuperType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrmliteExporter {
    private static final Logger logger = LoggerFactory.getLogger(OrmliteExporter.class);
    private final SQLCodegenModule module = new SQLCodegenModule();
    private final Set<String> classes = new HashSet<String>();
    private File targetFolder;
    @Nullable
    private String schemaPattern;
    @Nullable
    private String tableNamePattern;
    private boolean createScalaSources = false;
    private OrmliteEntityBeanSerializer beanSerializer;
    private TypeMappings typeMappings;
    private NamingStrategy namingStrategy;
    private Configuration configuration;
    private KeyDataFactory keyDataFactory;
    private boolean columnAnnotations = false;
    private boolean validationAnnotations = false;
    private boolean schemaToPackage = false;
    private String sourceEncoding = "UTF-8";
    private boolean lowerCase = false;
    private boolean exportTables = true;
    private boolean exportViews = true;
    private boolean exportAll = false;
    private boolean exportPrimaryKeys = true;
    private boolean exportForeignKeys = true;
    private boolean spatial = false;

    protected EntityModel createEntityModel(@Nullable String schemaName, String tableName, String className) {
        String packageName = this.normalizePackage(this.module.getPackageName(), schemaName);
        String simpleName = this.module.getBeanPrefix() + className + this.module.getSuffix();
        SimpleType classTypeModel = new SimpleType(TypeCategory.ENTITY, packageName + "." + simpleName, packageName, simpleName, false, false, new Type[0]);
        EntityModel entityModel = new EntityModel((Type)classTypeModel);
        this.typeMappings.register((Type)entityModel, (Type)entityModel);
        entityModel.getData().put("schema", schemaName);
        entityModel.getData().put("table", tableName);
        return this.finishEntityModel(entityModel);
    }

    protected EntityModel finishEntityModel(EntityModel model) {
        return model;
    }

    protected SuperType getSupertype(EntityModel entityType) {
        return null;
    }

    private String normalizePackage(String packageName, @Nullable String schemaName) {
        if (this.schemaToPackage && schemaName != null) {
            return this.namingStrategy.appendSchema(packageName, schemaName);
        }
        return packageName;
    }

    protected Property createProperty(EntityModel classModel, String normalizedColumnName, String propertyName, Type typeModel) {
        return new Property((EntityType)classModel, propertyName, propertyName, typeModel, Collections.emptyList(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void export(DatabaseMetaData md) throws SQLException {
        if (this.spatial) {
            SpatialSupport.addSupport((AbstractModule)this.module);
        }
        this.typeMappings = (TypeMappings)this.module.get(TypeMappings.class);
        this.namingStrategy = (NamingStrategy)this.module.get(NamingStrategy.class);
        this.configuration = (Configuration)this.module.get(Configuration.class);
        if (this.beanSerializer == null) {
            this.beanSerializer = new OrmliteEntityBeanSerializer();
        }
        this.keyDataFactory = new KeyDataFactory(this.namingStrategy, this.module.getPackageName(), this.module.getBeanPrefix(), this.module.getBeanSuffix(), this.schemaToPackage);
        String[] typesArray = null;
        if (!this.exportAll) {
            String[] types = new ArrayList(2);
            if (this.exportTables) {
                types.add("TABLE");
            }
            if (this.exportViews) {
                types.add("VIEW");
            }
            typesArray = types.toArray(new String[types.size()]);
        }
        if (this.tableNamePattern != null && this.tableNamePattern.contains(",")) {
            for (String table : this.tableNamePattern.split(",")) {
                try (ResultSet tables = md.getTables(null, this.schemaPattern, table.trim(), typesArray);){
                    while (tables.next()) {
                        this.handleTable(md, tables);
                    }
                }
            }
        } else {
            try (ResultSet tables = md.getTables(null, this.schemaPattern, this.tableNamePattern, typesArray);){
                while (tables.next()) {
                    this.handleTable(md, tables);
                }
            }
        }
    }

    Set<String> getClasses() {
        return this.classes;
    }

    private void handleColumn(EntityModel classModel, String tableName, ResultSet columns) throws SQLException {
        String columnName = this.normalize(columns.getString("COLUMN_NAME"));
        String normalizedColumnName = this.namingStrategy.normalizeColumnName(columnName);
        int columnType = columns.getInt("DATA_TYPE");
        String typeName = columns.getString("TYPE_NAME");
        Number columnSize = (Number)columns.getObject("COLUMN_SIZE");
        Number columnDigits = (Number)columns.getObject("DECIMAL_DIGITS");
        int columnIndex = columns.getInt("ORDINAL_POSITION");
        int nullable = columns.getInt("NULLABLE");
        String propertyName = this.namingStrategy.getPropertyName(normalizedColumnName, (EntityType)classModel);
        Class clazz = this.configuration.getJavaType(columnType, typeName, columnSize != null ? columnSize.intValue() : 0, columnDigits != null ? columnDigits.intValue() : 0, tableName, columnName);
        if (clazz == null) {
            throw new IllegalStateException("Found no mapping for " + columnType + " (" + tableName + "." + columnName + " " + typeName + ")");
        }
        TypeCategory fieldType = TypeCategory.get((String)clazz.getName());
        if (Number.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.NUMERIC;
        } else if (Enum.class.isAssignableFrom(clazz)) {
            fieldType = TypeCategory.ENUM;
        }
        ClassType typeModel = new ClassType(fieldType, clazz, new Type[0]);
        Property property = this.createProperty(classModel, normalizedColumnName, propertyName, (Type)typeModel);
        ColumnMetadata column = ColumnMetadata.named((String)normalizedColumnName).ofType(columnType).withIndex(columnIndex);
        if (nullable == 0) {
            column = column.notNull();
        }
        if (columnSize != null) {
            column = column.withSize(columnSize.intValue());
        }
        if (columnDigits != null) {
            column = column.withDigits(columnDigits.intValue());
        }
        property.getData().put("COLUMN", column);
        if (this.columnAnnotations) {
            property.addAnnotation((Annotation)new ColumnImpl(normalizedColumnName));
        }
        if (this.validationAnnotations) {
            int size;
            if (nullable == 0) {
                property.addAnnotation((Annotation)new NotNullImpl());
            }
            if ((size = columns.getInt("COLUMN_SIZE")) > 0 && clazz.equals(String.class)) {
                property.addAnnotation((Annotation)new SizeImpl(0, size));
            }
        }
        classModel.addProperty(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTable(DatabaseMetaData md, ResultSet tables) throws SQLException {
        Map primaryKeyData;
        String catalog = tables.getString("TABLE_CAT");
        String schema = tables.getString("TABLE_SCHEM");
        String schemaName = this.normalize(tables.getString("TABLE_SCHEM"));
        String tableName = this.normalize(tables.getString("TABLE_NAME"));
        String normalizedTableName = this.namingStrategy.normalizeTableName(tableName);
        String className = this.namingStrategy.getClassName(normalizedTableName);
        EntityModel classModel = this.createEntityModel(schemaName, normalizedTableName, className);
        if (this.exportPrimaryKeys && !(primaryKeyData = this.keyDataFactory.getPrimaryKeys(md, catalog, schema, tableName)).isEmpty()) {
            classModel.getData().put(PrimaryKeyData.class, primaryKeyData.values());
        }
        if (this.exportForeignKeys) {
            Map inverseForeignKeyData;
            Map foreignKeyData = this.keyDataFactory.getImportedKeys(md, catalog, schema, tableName);
            if (!foreignKeyData.isEmpty()) {
                classModel.getData().put(ForeignKeyData.class, foreignKeyData.values());
            }
            if (!(inverseForeignKeyData = this.keyDataFactory.getExportedKeys(md, catalog, schema, tableName)).isEmpty()) {
                classModel.getData().put(InverseForeignKeyData.class, inverseForeignKeyData.values());
            }
        }
        try (ResultSet columns = md.getColumns(catalog, schema, tableName.replace("/", "//"), null);){
            while (columns.next()) {
                this.handleColumn(classModel, tableName, columns);
            }
        }
        this.serialize(classModel);
        logger.info("Exported " + tableName + " successfully");
    }

    private String normalize(String str) {
        if (this.lowerCase && str != null) {
            return str.toLowerCase();
        }
        return str;
    }

    public void setSchemaPattern(@Nullable String schemaPattern) {
        this.schemaPattern = schemaPattern;
    }

    public void setTableNamePattern(@Nullable String tableNamePattern) {
        this.tableNamePattern = tableNamePattern;
    }

    public void setConfiguration(Configuration configuration) {
        this.module.bind(Configuration.class, (Object)configuration);
    }

    public void setCreateScalaSources(boolean createScalaSources) {
        this.createScalaSources = createScalaSources;
    }

    public void setTargetFolder(File targetFolder) {
        this.targetFolder = targetFolder;
    }

    public void setPackageName(String packageName) {
        this.module.bind("packageName", (Object)packageName);
    }

    public void setBeanPackageName(@Nullable String beanPackageName) {
        this.module.bind("beanPackageName", (Object)beanPackageName);
    }

    public void setNamePrefix(String namePrefix) {
        this.module.bind("prefix", (Object)namePrefix);
    }

    public void setNameSuffix(String nameSuffix) {
        this.module.bind("suffix", (Object)nameSuffix);
    }

    public void setBeanPrefix(String beanPrefix) {
        this.module.bind("beanPrefix", (Object)beanPrefix);
    }

    public void setBeanSuffix(String beanSuffix) {
        this.module.bind("beanSuffix", (Object)beanSuffix);
    }

    public void setNamingStrategy(NamingStrategy namingStrategy) {
        this.module.bind(NamingStrategy.class, (Object)namingStrategy);
    }

    public void setSerializer(@Nullable OrmliteEntityBeanSerializer beanSerializer) {
        this.beanSerializer = beanSerializer;
    }

    public void setInnerClassesForKeys(boolean innerClassesForKeys) {
        this.module.bind("innerClassesForKeys", (Object)innerClassesForKeys);
    }

    public void setColumnComparatorClass(Class<? extends Comparator<Property>> columnComparatorClass) {
        this.module.bind("columnComparator", columnComparatorClass);
    }

    public void setTypeMappings(TypeMappings typeMappings) {
        this.module.bind(TypeMappings.class, (Object)typeMappings);
    }

    public void setColumnAnnotations(boolean columnAnnotations) {
        this.columnAnnotations = columnAnnotations;
    }

    public void setValidationAnnotations(boolean validationAnnotations) {
        this.validationAnnotations = validationAnnotations;
    }

    public void setSourceEncoding(String sourceEncoding) {
        this.sourceEncoding = sourceEncoding;
    }

    public void setSchemaToPackage(boolean schemaToPackage) {
        this.schemaToPackage = schemaToPackage;
        this.module.bind("schemaToPackage", (Object)schemaToPackage);
    }

    public void setLowerCase(boolean lowerCase) {
        this.lowerCase = lowerCase;
    }

    public void setExportTables(boolean exportTables) {
        this.exportTables = exportTables;
    }

    public void setExportViews(boolean exportViews) {
        this.exportViews = exportViews;
    }

    public void setExportAll(boolean exportAll) {
        this.exportAll = exportAll;
    }

    public void setExportPrimaryKeys(boolean exportPrimaryKeys) {
        this.exportPrimaryKeys = exportPrimaryKeys;
    }

    public void setExportForeignKeys(boolean exportForeignKeys) {
        this.exportForeignKeys = exportForeignKeys;
    }

    public void setImports(String[] imports) {
        this.module.bind("imports", new HashSet<String>(Arrays.asList(imports)));
    }

    public void setSpatial(boolean spatial) {
        this.spatial = spatial;
    }

    private void serialize(EntityModel model) {
        try {
            String fileSuffix = this.createScalaSources ? ".scala" : ".java";
            String packageName = this.normalizePackage(this.module.getPackageName(), (String)model.getData().get("schema"));
            String path = packageName.replace('.', '/') + "/" + model.getSimpleName() + fileSuffix;
            File targetFile = new File(this.targetFolder, path);
            this.write(this.beanSerializer, targetFile, model);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private void write(OrmliteEntityBeanSerializer serializer, File targetFile, EntityModel model) throws IOException {
        this.classes.add(targetFile.getPath());
        StringWriter w = new StringWriter();
        ScalaWriter writer = this.createScalaSources ? new ScalaWriter((Appendable)w) : new JavaWriter((Appendable)w);
        serializer.serialize(model, SimpleSerializerConfig.DEFAULT, (CodeWriter)writer);
        this.finishWrite(targetFile, w);
    }

    protected void finishWrite(File targetFile, StringWriter w) throws IOException {
        boolean generate = true;
        byte[] bytes = w.toString().getBytes(this.sourceEncoding);
        if (targetFile.exists() && targetFile.length() == (long)bytes.length) {
            String str = Files.toString((File)targetFile, (Charset)Charset.forName(this.sourceEncoding));
            if (str.equals(w.toString())) {
                generate = false;
            }
        } else {
            targetFile.getParentFile().mkdirs();
        }
        if (generate) {
            Files.write((byte[])bytes, (File)targetFile);
        }
    }
}

