/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.codegen.core;

import com.querydsl.codegen.EntityType;
import com.querydsl.sql.codegen.DefaultNamingStrategy;

/**
 * 
 * @author <a href=mailto:hedyn@foxmail.com>HeDYn</a>
 *
 */
public class BasicNamingStrategy extends DefaultNamingStrategy {
    
    private String classNamePrefix;
    private String defaultVarName;
    
    public BasicNamingStrategy() {}

    public BasicNamingStrategy(String classNamePrefix, String defaultVarName) {
        this.classNamePrefix = classNamePrefix;
        this.defaultVarName = defaultVarName;
    }
    
    public void setClassNamePrefix(String classNamePrefix) {
        this.classNamePrefix = classNamePrefix;
    }

    public void setDefaultVarName(String defaultVarName) {
        this.defaultVarName = defaultVarName;
    }

    @Override
    public String getClassName(String tableName) {
        String className = super.getClassName(tableName);
        if (classNamePrefix != null) {
            className = classNamePrefix + className;
        }
        return className;
    }

    @Override
    public String getDefaultVariableName(EntityType entityType) {
        if (defaultVarName != null) {
            return defaultVarName;
        }
        return super.getDefaultVariableName(entityType);
    }
    
}
