/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.codegen.core;

import com.querydsl.codegen.EntityType;
import com.querydsl.codegen.Property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.TreeSet;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public final class CodegenUtils {
    
    private CodegenUtils() {}
    
    /**
     * 获取父类中没有的属性
     * @param model
     * @return
     */
    public static Set<Property> getProperties(EntityType model) {
        com.querydsl.codegen.Supertype supertype = model.getSuperType();
        if (supertype != null) {
            Class<?> superClass = supertype.getType().getJavaClass();
            Set<Property> properties = new TreeSet<Property>();
            for (Property property : model.getProperties()) {
                String propertyName = property.getEscapedName();
                if (findField(superClass, propertyName) == null) {
                    properties.add(property);
                }
            }
            return properties;
        }
        return model.getProperties();
    }
    
    public static Field findAccessibleField(Class<?> classType, String fieldName) {
        Field field = findField(classType, fieldName);
        if (field != null) {
            int modifiers = field.getModifiers();
            if (Modifier.isProtected(modifiers) || Modifier.isPublic(modifiers)) {
                return field;
            }
        }
        return null;
    }
    
    private static Field findField(Class<?> classType, String fieldName) {
        if (classType == null || classType == Object.class) {
            return null;
        }
        try {
            Field field = classType.getDeclaredField(fieldName);
            if (field != null) {
                return field;
            }
        } catch (Exception ex) {
        }
        return findField(classType.getSuperclass(), fieldName);
    }
    
    /**
     * 获取指定类的名称
     * @param classType
     * @return
     * @see {@link Class#getTypeName()}}
     */
    public static String getTypeName(Class<?> classType) {
        if (classType.isArray()) {
            try {
                Class<?> cl = classType;
                int dimensions = 0;
                while (cl.isArray()) {
                    dimensions++;
                    cl = cl.getComponentType();
                }
                StringBuilder sb = new StringBuilder();
                sb.append(cl.getName());
                for (int i = 0; i < dimensions; i++) {
                    sb.append("[]");
                }
                return sb.toString();
            } catch (Throwable e) { /*FALLTHRU*/ }
        }
        return classType.getName();
    }

}
