/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.codegen.core;

import com.google.common.collect.Lists;
import com.mysema.codegen.model.ClassType;
import com.mysema.codegen.model.Type;
import com.querydsl.codegen.EntityType;

import java.util.List;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public class EntityModel extends EntityType {
    
    private List<Type> interfaces = Lists.newArrayList();
    private SuperType supertype;

    public EntityModel(Type type) {
        super(type);
    }

    public EntityModel(Type type, SuperType supertype) {
        this(type);
        this.supertype = supertype;
    }
    
    public void addInterface(Class<?> iface) {
        interfaces.add(new ClassType(iface));
    }

    public void addInterface(Type iface) {
        interfaces.add(iface);
    }
    
    public List<Type> getInterfaces() {
        return interfaces;
    }
    
    @Override
    public SuperType getSuperType() {
        return supertype;
    }
    
    public void setSupertype(SuperType supertype) {
        this.supertype = supertype;
        super.addSupertype(supertype);
    }
}
