/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.codegen.core;

import com.mysema.codegen.model.Type;
import net.apexes.commons.querydsl.info.IndexColumn;
import net.apexes.commons.querydsl.info.IndexInfo;

import javax.annotation.Nullable;
import java.util.List;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public class IndexData {
    
    private final IndexInfo info;
    
    @Nullable
    private final Type type;
    
    public IndexData(IndexInfo info, Type type) {
        this.info = info;
        this.type = type;
    }

    public String getName() {
        return info.getName();
    }
    
    public String getSchema() {
        return info.getSchema();
    }

    public String getTable() {
        return info.getTable();
    }
    
    public boolean isUnique() {
        return info.isUnique();
    }
    
    public List<IndexColumn> getColumns() {
        return info.getColumns();
    }

    public Type getType() {
        return type;
    }

}
