/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.client;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.zip.GZIPInputStream;
import net.apexes.wsonrpc.core.JsonRpcEngine;
import net.apexes.wsonrpc.core.Remote;
import net.apexes.wsonrpc.core.RemoteException;
import net.apexes.wsonrpc.core.Transport;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.json.JsonImplementor;

public class HttpJsonRpcRemote
implements Remote {
    protected final URL url;
    protected final Map<String, String> headers;
    protected final JsonRpcEngine jsonRpcEngine;
    protected final Random rand;
    private int connectTimeout;
    private boolean acceptCompress;

    public HttpJsonRpcRemote(URL url, JsonImplementor jsonImpl) {
        this.url = url;
        this.headers = new HashMap<String, String>();
        this.jsonRpcEngine = new JsonRpcEngine(jsonImpl);
        this.rand = new Random();
    }

    protected final void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public final void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public boolean isAcceptCompress() {
        return this.acceptCompress;
    }

    public void setAcceptCompress(boolean value) {
        this.acceptCompress = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(String handlerName, String methodName, Object[] args) throws IOException, WsonrpcException {
        try (TransportImpl transport = new TransportImpl(this.url, this.headers, this.connectTimeout, 0, this.acceptCompress);){
            this.jsonRpcEngine.invoke(handlerName, methodName, args, null, (Transport)transport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T invoke(String handlerName, String methodName, Object[] args, Class<T> returnType, int timeout) throws IOException, WsonrpcException, RemoteException {
        try (TransportImpl transport = new TransportImpl(this.url, this.headers, this.connectTimeout, timeout, this.acceptCompress);){
            int id = this.rand.nextInt(Integer.MAX_VALUE);
            this.jsonRpcEngine.invoke(handlerName, methodName, args, String.valueOf(id), (Transport)transport);
            Object object = this.jsonRpcEngine.receiveResponse(transport.readBinary(), returnType);
            return (T)object;
        }
    }

    public <T> Future<T> asyncInvoke(String handleName, String methodName, Object[] args, Class<T> returnType) throws IOException, WsonrpcException {
        throw new UnsupportedOperationException();
    }

    private static class TransportImpl
    implements Transport {
        private final HttpURLConnection conn;

        TransportImpl(URL url, Map<String, String> headers, int connectTimeout, int readTimeout, boolean acceptCompress) throws IOException {
            this.conn = (HttpURLConnection)url.openConnection();
            this.conn.setRequestProperty("Connection", "close");
            this.conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    this.conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (acceptCompress) {
                this.conn.setRequestProperty("Accept-Encoding", "gzip");
            }
            this.conn.setRequestMethod("POST");
            this.conn.setConnectTimeout(connectTimeout);
            this.conn.setReadTimeout(readTimeout);
            this.conn.setDoOutput(true);
            this.conn.setDoInput(true);
            this.conn.connect();
        }

        public void sendBinary(byte[] bytes) throws IOException {
            OutputStream out = this.conn.getOutputStream();
            out.write(bytes);
            out.flush();
        }

        public byte[] readBinary() throws IOException {
            int len;
            int statusCode = this.conn.getResponseCode();
            if (statusCode != 200) {
                throw new IOException("unexpected status code returned : " + statusCode + ", message : " + this.conn.getResponseMessage());
            }
            String responseEncoding = this.conn.getHeaderField("Content-Encoding");
            responseEncoding = responseEncoding == null ? "" : responseEncoding.trim();
            BufferedInputStream in = null;
            in = "gzip".equalsIgnoreCase(responseEncoding) ? new BufferedInputStream(new GZIPInputStream(this.conn.getInputStream())) : new BufferedInputStream(this.conn.getInputStream());
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) != -1) {
                out.write(buf, 0, len);
            }
            return out.toByteArray();
        }

        public void close() {
            this.conn.disconnect();
        }
    }
}

