/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.client;

import java.net.URI;
import java.net.URISyntaxException;
import net.apexes.wsonrpc.client.WebsocketConnector;
import net.apexes.wsonrpc.client.WsonrpcClient;
import net.apexes.wsonrpc.client.WsonrpcClientConfig;
import net.apexes.wsonrpc.client.WsonrpcClientImpl;
import net.apexes.wsonrpc.client.support.SimpleWebsocketConnector;
import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.Remote;
import net.apexes.wsonrpc.core.RemoteInvoker;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcConfigBuilder;
import net.apexes.wsonrpc.core.WsonrpcErrorProcessor;
import net.apexes.wsonrpc.core.WsonrpcInterceptor;
import net.apexes.wsonrpc.json.JsonImplementor;

public class WsonrpcClientConfigBuilder {
    private final WsonrpcConfigBuilder builder = WsonrpcConfigBuilder.create();
    private WebsocketConnector connector;
    private int connectTimeout;

    public static WsonrpcClientConfigBuilder create() {
        return new WsonrpcClientConfigBuilder();
    }

    private WsonrpcClientConfigBuilder() {
    }

    public WsonrpcClientConfigBuilder json(JsonImplementor jsonImpl) {
        this.builder.json(jsonImpl);
        return this;
    }

    public WsonrpcClientConfigBuilder binaryWrapper(BinaryWrapper binaryWrapper) {
        this.builder.binaryWrapper(binaryWrapper);
        return this;
    }

    public WsonrpcClientConfigBuilder errorProcessor(WsonrpcErrorProcessor errorProcessor) {
        this.builder.errorProcessor(errorProcessor);
        return this;
    }

    public WsonrpcClientConfigBuilder connector(WebsocketConnector connector) {
        this.connector = connector;
        return this;
    }

    public WsonrpcClientConfigBuilder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public WsonrpcClient client(String url) throws URISyntaxException {
        if (this.connector == null) {
            this.connector = new SimpleWebsocketConnector();
        }
        URI uri = new URI(url);
        WsonrpcClientConfigImpl config = new WsonrpcClientConfigImpl(this.builder.build(), uri, this.connector, this.connectTimeout);
        return new WsonrpcClientImpl(config);
    }

    public RemoteInvoker invoker(WsonrpcClient client) {
        return RemoteInvoker.create((Remote)client);
    }

    private static class WsonrpcClientConfigImpl
    implements WsonrpcClientConfig {
        private final WsonrpcConfig config;
        private final URI uri;
        private final WebsocketConnector connector;
        private final int connectTimeout;

        private WsonrpcClientConfigImpl(WsonrpcConfig config, URI uri, WebsocketConnector connector, int connectTimeout) {
            this.config = config;
            this.uri = uri;
            this.connector = connector;
            this.connectTimeout = connectTimeout;
        }

        public JsonImplementor getJsonImplementor() {
            return this.config.getJsonImplementor();
        }

        public BinaryWrapper getBinaryWrapper() {
            return this.config.getBinaryWrapper();
        }

        public WsonrpcInterceptor getWsonrpcInterceptor() {
            return this.config.getWsonrpcInterceptor();
        }

        public WsonrpcErrorProcessor getErrorProcessor() {
            return this.config.getErrorProcessor();
        }

        @Override
        public URI getURI() {
            return this.uri;
        }

        @Override
        public WebsocketConnector getWebsocketConnector() {
            return this.connector;
        }

        @Override
        public int getConnectTimeout() {
            return this.connectTimeout;
        }
    }
}

