/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.client;

import java.io.IOException;
import net.apexes.wsonrpc.client.WsonrpcClient;
import net.apexes.wsonrpc.client.WsonrpcClientConfig;
import net.apexes.wsonrpc.client.WsonrpcClientEndpoint;
import net.apexes.wsonrpc.client.WsonrpcClientListener;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcEndpoint;

public class WsonrpcClientImpl
extends WsonrpcEndpoint
implements WsonrpcClient,
WsonrpcClientEndpoint {
    private final WsonrpcClientConfig config;
    private WsonrpcClientListener clientListener;

    protected WsonrpcClientImpl(WsonrpcClientConfig config) {
        super((WsonrpcConfig)config);
        this.config = config;
    }

    private synchronized void fireOpen() {
        if (this.clientListener != null) {
            this.clientListener.onOpen(this);
        }
    }

    private synchronized void fireClose(int code, String reason) {
        if (this.clientListener != null) {
            this.clientListener.onClose(this, code, reason);
        }
    }

    private synchronized void fireSentMessage(byte[] bytes) {
        if (this.clientListener != null) {
            this.clientListener.onSentMessage(bytes);
        }
    }

    private synchronized void fireSentPing() {
        if (this.clientListener != null) {
            this.clientListener.onSentPing();
        }
    }

    @Override
    public void connect() throws Exception {
        if (!this.isConnected()) {
            this.config.getWebsocketConnector().connectToServer(this, this.config.getURI());
        }
    }

    @Override
    public void onOpen(WebSocketSession session) {
        this.online(new WsonrpcSessionProxy(session));
        this.fireOpen();
    }

    @Override
    public void onMessage(byte[] bytes) {
        this.wsonrpcEngine.handle(this.getSession(), bytes);
    }

    @Override
    public void onError(Throwable error) {
        if (this.config.getErrorProcessor() != null) {
            this.config.getErrorProcessor().onError(this.getSessionId(), error);
        }
    }

    @Override
    public void onClose(int code, String reason) {
        this.offline();
        this.fireClose(code, reason);
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.wsonrpcEngine.getServiceRegistry();
    }

    @Override
    public int getConnectTimeout() {
        return this.config.getConnectTimeout();
    }

    @Override
    public void setClientListener(WsonrpcClientListener listener) {
        this.clientListener = listener;
    }

    private class WsonrpcSessionProxy
    implements WebSocketSession {
        private final WebSocketSession session;

        private WsonrpcSessionProxy(WebSocketSession session) {
            this.session = session;
        }

        public String getId() {
            return this.session.getId();
        }

        public boolean isOpen() {
            return this.session.isOpen();
        }

        public void sendBinary(byte[] bytes) throws IOException {
            this.session.sendBinary(bytes);
            WsonrpcClientImpl.this.fireSentMessage(bytes);
        }

        public void ping() throws IOException {
            this.session.ping();
            WsonrpcClientImpl.this.fireSentPing();
        }

        public void close() throws IOException {
            this.session.close();
        }
    }
}

