/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.client.support;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import net.apexes.wsonrpc.client.WebsocketConnector;
import net.apexes.wsonrpc.client.WsonrpcClientEndpoint;
import net.apexes.wsonrpc.core.WebSocketSession;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.PingFrame;
import org.java_websocket.handshake.ServerHandshake;

public class JavaWebsocketConnector
implements WebsocketConnector {
    @Override
    public void connectToServer(WsonrpcClientEndpoint endpoint, URI uri) throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        WebSocketClientAdapter clientAdapter = new WebSocketClientAdapter(uri, endpoint, latch);
        clientAdapter.connectBlocking();
        int timeout = endpoint.getConnectTimeout();
        if (timeout > 0) {
            latch.await(timeout, TimeUnit.MILLISECONDS);
        } else {
            latch.await();
        }
    }

    private static class WebSocketClientAdapter
    extends WebSocketClient
    implements WebSocketSession {
        private static PingFrame PING_FRAME = new PingFrame();
        private final WsonrpcClientEndpoint endpoint;
        private final CountDownLatch latch;
        private String id;
        private volatile boolean opened;

        public WebSocketClientAdapter(URI uri, WsonrpcClientEndpoint endpoint, CountDownLatch latch) {
            super(uri);
            this.endpoint = endpoint;
            this.latch = latch;
        }

        public void onOpen(ServerHandshake handshakedata) {
            this.id = UUID.randomUUID().toString();
            this.opened = true;
            this.endpoint.onOpen(this);
            this.latch.countDown();
        }

        public void onMessage(String message) {
            try {
                this.endpoint.onMessage(message.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }

        public void onMessage(ByteBuffer bytes) {
            this.endpoint.onMessage(bytes.array());
        }

        public void onClose(int code, String reason, boolean remote) {
            this.opened = false;
            this.endpoint.onClose(code, reason);
        }

        public void onError(Exception error) {
            this.endpoint.onError(error);
        }

        public String getId() {
            return this.id;
        }

        public boolean isOpen() {
            return this.opened;
        }

        public void sendBinary(byte[] bytes) throws IOException {
            this.send(bytes);
        }

        public void ping() throws IOException {
            this.getConnection().sendFrame((Framedata)PING_FRAME);
        }
    }
}

