/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.client.support;

import java.io.IOException;
import java.net.URI;
import java.util.UUID;
import net.apexes.wsonrpc.client.WebsocketConnector;
import net.apexes.wsonrpc.client.WsonrpcClientEndpoint;
import net.apexes.wsonrpc.client.support.websocket.WebSocketClient;
import net.apexes.wsonrpc.client.support.websocket.WebSocketEventHandler;
import net.apexes.wsonrpc.client.support.websocket.WebSocketException;
import net.apexes.wsonrpc.client.support.websocket.WebSocketMessage;
import net.apexes.wsonrpc.core.WebSocketSession;

public class SimpleWebsocketConnector
implements WebsocketConnector {
    @Override
    public void connectToServer(WsonrpcClientEndpoint endpoint, URI uri) throws Exception {
        WebSocketClient wsClient = new WebSocketClient(uri);
        wsClient.setEventHandler(new WebSocketClientProxy(endpoint, wsClient));
        wsClient.connect();
    }

    private static class WebSocketClientProxy
    implements WebSocketSession,
    WebSocketEventHandler {
        private final WsonrpcClientEndpoint endpoint;
        private final WebSocketClient wsClient;
        private String id;
        private volatile boolean opened;

        WebSocketClientProxy(WsonrpcClientEndpoint endpoint, WebSocketClient wsClient) {
            this.endpoint = endpoint;
            this.wsClient = wsClient;
            this.opened = false;
        }

        @Override
        public void onOpen() {
            this.id = UUID.randomUUID().toString();
            this.opened = true;
            this.endpoint.onOpen(this);
        }

        @Override
        public void onClose() {
            if (this.opened) {
                this.opened = false;
                this.wsClient.close();
                this.endpoint.onClose(0, "");
            }
        }

        @Override
        public void onMessage(WebSocketMessage message) {
            this.endpoint.onMessage(message.getBytes());
        }

        @Override
        public void onError(WebSocketException error) {
            this.endpoint.onError(error);
        }

        @Override
        public void onLogMessage(String msg) {
        }

        public String getId() {
            return this.id;
        }

        public boolean isOpen() {
            return this.opened;
        }

        public void sendBinary(byte[] data) throws IOException {
            this.wsClient.send(data);
        }

        public void ping() throws IOException {
            this.wsClient.ping();
        }

        public void close() throws IOException {
            this.wsClient.close();
        }
    }
}

