/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.client.support;

import java.net.URI;
import java.nio.ByteBuffer;
import javax.websocket.ClientEndpoint;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import net.apexes.wsonrpc.client.WebsocketConnector;
import net.apexes.wsonrpc.client.WsonrpcClientEndpoint;
import net.apexes.wsonrpc.core.websocket.WebSockets;
import org.glassfish.tyrus.client.ClientManager;
import org.glassfish.tyrus.container.jdk.client.JdkClientContainer;

public class TyrusWebsocketConnector
implements WebsocketConnector {
    @Override
    public void connectToServer(WsonrpcClientEndpoint endpoint, URI uri) throws Exception {
        ClientManager mgr = ClientManager.createClient((String)JdkClientContainer.class.getName());
        mgr.connectToServer((Object)new WebSocketEndpointAdapter(endpoint), uri);
    }

    @ClientEndpoint
    public static class WebSocketEndpointAdapter {
        private final WsonrpcClientEndpoint endpoint;

        public WebSocketEndpointAdapter(WsonrpcClientEndpoint endpoint) {
            this.endpoint = endpoint;
        }

        @OnOpen
        public void onOpen(Session session) {
            this.endpoint.onOpen(WebSockets.createSession((Session)session));
        }

        @OnMessage
        public void onMessage(ByteBuffer buffer) {
            this.endpoint.onMessage(buffer.array());
        }

        @OnError
        public void onError(Throwable error) {
            this.endpoint.onError(error);
        }

        @OnClose
        public void onClose(CloseReason closeReason) {
            this.endpoint.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        }
    }
}

