/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.apexes.wsonrpc.core.WsonrpcFuture;
import net.apexes.wsonrpc.core.WsonrpcIdKey;

final class Futures {
    private static final Map<WsonrpcIdKey, WeakElement> MAP = new ConcurrentHashMap<WsonrpcIdKey, WeakElement>();
    private static final ReferenceQueue<WsonrpcFuture<Object>> QUEUE = new ReferenceQueue();

    private Futures() {
    }

    static void put(WsonrpcFuture<Object> future) {
        Futures.processQueue();
        MAP.put(future.idKey, new WeakElement(future, QUEUE));
    }

    static WsonrpcFuture<Object> out(String id) {
        return Futures.out(new WsonrpcIdKey.StringIdKey(id));
    }

    static WsonrpcFuture<Object> out(Object key) {
        Futures.processQueue();
        WeakElement ref = MAP.remove(key);
        if (ref != null) {
            return (WsonrpcFuture)ref.get();
        }
        return null;
    }

    static final void processQueue() {
        Reference<WsonrpcFuture<Object>> ref = null;
        while ((ref = QUEUE.poll()) != null) {
            MAP.remove(ref);
        }
    }

    private static class WeakElement
    extends WeakReference<WsonrpcFuture<Object>>
    implements WsonrpcIdKey {
        private WsonrpcIdKey idKey;

        WeakElement(WsonrpcFuture<Object> future, ReferenceQueue<WsonrpcFuture<Object>> queue) {
            super(future, queue);
            this.idKey = future.idKey;
        }

        @Override
        public String id() {
            return this.idKey.id();
        }

        public int hashCode() {
            return this.idKey.id().hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o instanceof WsonrpcIdKey) {
                WsonrpcIdKey ik = (WsonrpcIdKey)o;
                return this.id().equals(ik.id());
            }
            return false;
        }

        public String toString() {
            return "WeakElement [id=" + this.id() + "]";
        }
    }
}

