/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.RemoteException;
import net.apexes.wsonrpc.core.ServiceEntry;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.Transport;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.message.JsonRpcError;
import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.core.message.JsonRpcRequest;
import net.apexes.wsonrpc.core.message.JsonRpcResponse;
import net.apexes.wsonrpc.json.JsonImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcControl
implements ServiceRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcControl.class);
    private final JsonImplementor jsonImpl;
    private final BinaryWrapper binaryWrapper;
    private final Map<String, ServiceEntry<?>> services;

    public JsonRpcControl(JsonImplementor jsonImpl) {
        this(jsonImpl, null);
    }

    protected JsonRpcControl(JsonImplementor jsonImpl, BinaryWrapper binaryWrapper) {
        if (jsonImpl == null) {
            throw new NullPointerException("jsonImpl");
        }
        this.jsonImpl = jsonImpl;
        this.binaryWrapper = binaryWrapper;
        this.services = new HashMap();
    }

    public JsonImplementor getJsonImplementor() {
        return this.jsonImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> ServiceRegistry register(String name, T service, Class<?> ... classes) {
        ServiceEntry<T> serviceEntry = new ServiceEntry<T>(service, classes);
        Map<String, ServiceEntry<?>> map = this.services;
        synchronized (map) {
            if (this.services.containsKey(name)) {
                throw new IllegalArgumentException("service already exists");
            }
            this.services.put(name, serviceEntry);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceRegistry unregister(String name) {
        Map<String, ServiceEntry<?>> map = this.services;
        synchronized (map) {
            this.services.remove(name);
        }
        return this;
    }

    public void receiveRequest(byte[] bytes, Transport transport) throws IOException, WsonrpcException {
        JsonRpcMessage msg = this.receive(bytes);
        if (!(msg instanceof JsonRpcRequest)) {
            throw new WsonrpcException("Invalid Request");
        }
        JsonRpcRequest req = (JsonRpcRequest)msg;
        JsonRpcResponse resp = this.execute(req);
        this.transmit(transport, resp);
    }

    public <T> T receiveResponse(byte[] bytes, Class<T> returnType) throws IOException, WsonrpcException {
        JsonRpcMessage msg = this.receive(bytes);
        if (msg instanceof JsonRpcResponse) {
            return this.convertResponse((JsonRpcResponse)msg, returnType);
        }
        throw new WsonrpcException("Invalid Response");
    }

    public void invoke(String serviceName, String methodName, Object[] args, String id, Transport transport) throws IOException, WsonrpcException {
        if (methodName == null) {
            throw new NullPointerException("methodName");
        }
        String method = serviceName == null ? methodName : serviceName + "." + methodName;
        JsonImplementor.Node[] params = null;
        if (args != null) {
            params = new JsonImplementor.Node[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = this.jsonImpl.convert(args[i]);
            }
        }
        this.transmit(transport, new JsonRpcRequest(id, method, params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonRpcResponse execute(JsonRpcRequest request) {
        ServiceEntry<?> serviceEntry;
        if (request == null) {
            return new JsonRpcResponse(null, JsonRpcError.parseError(null));
        }
        String serviceName = null;
        String methodName = request.getMethod();
        int lastIndex = methodName.lastIndexOf(46);
        if (lastIndex >= 0) {
            serviceName = methodName.substring(0, lastIndex);
            methodName = methodName.substring(lastIndex + 1);
        }
        Map<String, ServiceEntry<?>> map = this.services;
        synchronized (map) {
            serviceEntry = this.services.get(serviceName);
        }
        if (serviceEntry == null) {
            return new JsonRpcResponse(null, JsonRpcError.methodNotFoundError(null));
        }
        Set<Method> methods = serviceEntry.getMethods(methodName);
        if (methods == null || methods.isEmpty()) {
            return new JsonRpcResponse(null, JsonRpcError.methodNotFoundError(null));
        }
        JsonImplementor.Node[] params = request.getParams();
        Method method = this.findExecutableMethod(methods, params);
        if (method == null) {
            return new JsonRpcResponse(null, JsonRpcError.invalidParamsError(null));
        }
        try {
            Object[] args = this.getParameters(method, params);
            Object invokeValue = method.invoke(serviceEntry.getService(), args);
            if (request.isNotice()) {
                return null;
            }
            JsonImplementor.Node result = this.jsonImpl.convert(invokeValue);
            return new JsonRpcResponse(request.getId(), result);
        }
        catch (Throwable t) {
            LOG.warn("executing error : " + methodName, t);
            if (t instanceof InvocationTargetException) {
                t = ((InvocationTargetException)t).getTargetException();
            }
            return new JsonRpcResponse(null, JsonRpcError.serverError(1, t));
        }
    }

    protected Method findExecutableMethod(Set<Method> methods, JsonImplementor.Node[] params) {
        if (params == null) {
            for (Method method : methods) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length != 0) continue;
                return method;
            }
        } else {
            for (Method method : methods) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length != params.length) continue;
                boolean compatible = true;
                for (int i = 0; i < types.length; ++i) {
                    if (this.jsonImpl.isCompatible(params[i], types[i])) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) continue;
                return method;
            }
        }
        return null;
    }

    protected Object[] getParameters(Method method, JsonImplementor.Node[] params) {
        Object[] args = new Object[params.length];
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            JsonImplementor.Node node = params[i];
            args[i] = this.jsonImpl.convert(node, types[i]);
        }
        return args;
    }

    protected <T> T convertResponse(JsonRpcResponse resp, Class<T> returnType) throws WsonrpcException {
        if (resp.getError() != null) {
            throw new RemoteException(resp.getError());
        }
        if (resp.getResult() == null) {
            return null;
        }
        try {
            return this.jsonImpl.convert(resp.getResult(), returnType);
        }
        catch (Throwable t) {
            throw new WsonrpcException(t);
        }
    }

    protected void transmit(Transport transport, JsonRpcMessage message) throws IOException, WsonrpcException {
        String json;
        try {
            json = message.toJson(this.jsonImpl);
        }
        catch (Exception e) {
            throw new WsonrpcException("Serialize failed", e);
        }
        LOG.debug(" >>  {}", (Object)json);
        byte[] bytes = json.getBytes("UTF-8");
        if (this.binaryWrapper != null) {
            LOG.debug(" = {}", (Object)bytes.length);
            bytes = this.binaryWrapper.write(bytes);
            LOG.debug(" - {}", (Object)bytes.length);
        }
        transport.sendBinary(bytes);
    }

    protected JsonRpcMessage receive(byte[] bytes) throws IOException, WsonrpcException {
        if (this.binaryWrapper != null) {
            LOG.debug(" - {}", (Object)bytes.length);
            bytes = this.binaryWrapper.read(bytes);
            LOG.debug(" = {}", (Object)bytes.length);
        }
        String json = new String(bytes, "UTF-8");
        LOG.debug(" <<  {}", (Object)json);
        try {
            return JsonRpcMessage.of(this.jsonImpl, json);
        }
        catch (Exception e) {
            throw new WsonrpcException("Parse error", e);
        }
    }
}

