/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.message.JsonRpcError;

public class RemoteException
extends WsonrpcException {
    private static final long serialVersionUID = 1L;
    private final JsonRpcError error;

    public RemoteException(JsonRpcError error) {
        super(RemoteException.format(error));
        this.error = error;
    }

    public JsonRpcError getJsonRpcError() {
        return this.error;
    }

    private static String format(JsonRpcError error) {
        StringBuilder str = new StringBuilder();
        str.append("jsonrpc error");
        if (error.getCode() != null) {
            str.append("[").append(error.getCode()).append("]");
        }
        str.append(" : ");
        if (error.getMessage() != null) {
            str.append(error.getMessage());
        }
        if (error.getData() != null) {
            str.append("\n");
            str.append("Caused by " + error.getData());
        }
        return str.toString();
    }
}

