/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ServiceEntry<T> {
    private final T service;
    private final Map<String, Set<Method>> methods;

    public ServiceEntry(T service, Class<?> ... classes) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        if (classes.length == 0) {
            throw new IllegalArgumentException("none interface");
        }
        this.service = service;
        HashMap<String, HashSet<Method>> map = new HashMap<String, HashSet<Method>>();
        Class<?> serviceClass = service.getClass();
        for (Class<?> clazz : classes) {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("class should be an interface : " + clazz);
            }
            for (Method m : clazz.getMethods()) {
                Method method;
                String methodName = m.getName();
                Class<?>[] params = m.getParameterTypes();
                try {
                    method = serviceClass.getMethod(methodName, params);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("not implements method : " + methodName + ServiceEntry.argumentTypesToString(params));
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("access error : " + methodName + ServiceEntry.argumentTypesToString(params), e);
                }
                HashSet<Method> set = (HashSet<Method>)map.get(methodName);
                if (set == null) {
                    set = new HashSet<Method>();
                    map.put(methodName, set);
                }
                set.add(method);
            }
        }
        this.methods = Collections.unmodifiableMap(map);
    }

    public T getService() {
        return this.service;
    }

    public Set<Method> getMethods(String methodName) {
        return this.methods.get(methodName);
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

