/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.util.concurrent.Executor;
import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.support.GsonImplementor;

public final class WsonrpcConfigBuilder {
    private JsonImplementor jsonImpl;
    private BinaryWrapper binaryWrapper;
    private Executor executor;

    public static WsonrpcConfig defaultConfig() {
        return WsonrpcConfigBuilder.create().build();
    }

    public static WsonrpcConfigBuilder create() {
        return new WsonrpcConfigBuilder();
    }

    private WsonrpcConfigBuilder() {
    }

    public WsonrpcConfig build() {
        if (this.jsonImpl == null) {
            this.jsonImpl = new GsonImplementor();
        }
        if (this.executor == null) {
            this.executor = new Executor(){

                @Override
                public void execute(Runnable runnable) {
                    runnable.run();
                }
            };
        }
        return new WsonrpcConfig(){

            @Override
            public JsonImplementor getJsonImplementor() {
                return WsonrpcConfigBuilder.this.jsonImpl;
            }

            @Override
            public BinaryWrapper getBinaryWrapper() {
                return WsonrpcConfigBuilder.this.binaryWrapper;
            }

            @Override
            public Executor getExecutor() {
                return WsonrpcConfigBuilder.this.executor;
            }
        };
    }

    public WsonrpcConfigBuilder json(JsonImplementor jsonImpl) {
        this.jsonImpl = jsonImpl;
        return this;
    }

    public WsonrpcConfigBuilder binaryWrapper(BinaryWrapper binaryWrapper) {
        this.binaryWrapper = binaryWrapper;
        return this;
    }

    public WsonrpcConfigBuilder executor(Executor executor) {
        this.executor = executor;
        return this;
    }
}

