/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.Future;
import net.apexes.wsonrpc.core.Futures;
import net.apexes.wsonrpc.core.JsonRpcControl;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcErrorProcessor;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.WsonrpcFuture;
import net.apexes.wsonrpc.core.WsonrpcSession;
import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.core.message.JsonRpcRequest;
import net.apexes.wsonrpc.core.message.JsonRpcResponse;

public class WsonrpcControl
implements ServiceRegistry {
    protected final WsonrpcConfig config;
    protected final JsonRpcControl jsonRpcControl;

    public WsonrpcControl(WsonrpcConfig config) {
        if (config == null) {
            throw new NullPointerException("config");
        }
        this.config = config;
        this.jsonRpcControl = new JsonRpcControl(config.getJsonImplementor(), config.getBinaryWrapper());
    }

    public final WsonrpcConfig getConfig() {
        return this.config;
    }

    public Future<Object> invoke(WsonrpcSession session, String serviceName, String methodName, Object[] args, Class<?> returnType) throws IOException, WsonrpcException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        WsonrpcFuture<Object> future = new WsonrpcFuture<Object>(id, returnType);
        Futures.put(future);
        try {
            this.jsonRpcControl.invoke(serviceName, methodName, args, id, session);
            return future;
        }
        catch (Throwable t) {
            Futures.out(id);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof WsonrpcException) {
                throw (WsonrpcException)t;
            }
            throw new WsonrpcException(t);
        }
    }

    public void invoke(WsonrpcSession session, String serviceName, String methodName, Object[] args) throws IOException, WsonrpcException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.jsonRpcControl.invoke(serviceName, methodName, args, null, session);
    }

    public void handle(final WsonrpcSession session, byte[] bytes, final WsonrpcErrorProcessor errorProcessor) throws IOException, WsonrpcException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        final JsonRpcMessage msg = this.jsonRpcControl.receive(bytes);
        if (msg instanceof JsonRpcRequest) {
            this.config.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            WsonrpcControl.this.handleRequest(session, (JsonRpcRequest)msg);
                        }
                        catch (Exception e) {
                            if (errorProcessor == null) break block2;
                            errorProcessor.onError(session.getId(), e);
                        }
                    }
                }
            });
        } else if (msg instanceof JsonRpcResponse) {
            JsonRpcResponse resp = (JsonRpcResponse)msg;
            String id = resp.getId();
            if (id == null) {
                return;
            }
            WsonrpcFuture<Object> future = Futures.out(id);
            try {
                Object value = this.jsonRpcControl.convertResponse(resp, future.returnType);
                future.set(value);
            }
            catch (Throwable t) {
                future.setException(t);
            }
        }
    }

    protected void handleRequest(WsonrpcSession session, JsonRpcRequest request) throws IOException, WsonrpcException {
        JsonRpcResponse resp = this.jsonRpcControl.execute(request);
        if (resp != null) {
            this.jsonRpcControl.transmit(session, resp);
        }
    }

    @Override
    public <T> ServiceRegistry register(String name, T service, Class<?> ... classes) {
        return this.jsonRpcControl.register(name, service, classes);
    }

    @Override
    public ServiceRegistry unregister(String name) {
        return this.jsonRpcControl.unregister(name);
    }
}

