/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.apexes.wsonrpc.core.Futures;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcControl;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.WsonrpcRemote;
import net.apexes.wsonrpc.core.WsonrpcSession;

public class WsonrpcEndpoint
implements WsonrpcRemote {
    protected final WsonrpcControl wsonrpcControl;
    private WsonrpcSession session;

    protected WsonrpcEndpoint(WsonrpcConfig config) {
        this.wsonrpcControl = new WsonrpcControl(config);
    }

    protected final void online(WsonrpcSession session) {
        this.session = session;
    }

    protected final void offline() {
        this.session = null;
    }

    protected WsonrpcSession getSession() {
        return this.session;
    }

    protected void verifyOnline() throws WsonrpcException {
        if (!this.isConnected()) {
            throw new WsonrpcException("Connection is closed.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public String getSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    @Override
    public void disconnect() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Override
    public void ping() throws Exception {
        this.verifyOnline();
        this.session.ping();
    }

    @Override
    public void invoke(String handleName, String methodName, Object[] args) throws IOException, WsonrpcException {
        this.verifyOnline();
        this.wsonrpcControl.invoke(this.getSession(), handleName, methodName, args);
    }

    @Override
    public <T> T invoke(String handleName, String methodName, Object[] args, Class<T> returnType, int timeout) throws IOException, WsonrpcException {
        Future<T> future = this.asyncInvoke(handleName, methodName, args, returnType);
        try {
            if (timeout <= 0) {
                return future.get();
            }
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Futures.out(future);
            throw new WsonrpcException(e);
        }
    }

    @Override
    public <T> Future<T> asyncInvoke(String handleName, String methodName, Object[] args, Class<T> returnType) throws IOException, WsonrpcException {
        this.verifyOnline();
        return this.wsonrpcControl.invoke(this.getSession(), handleName, methodName, args, returnType);
    }
}

