/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.message;

import net.apexes.wsonrpc.core.message.JsonRpcError;
import net.apexes.wsonrpc.core.message.JsonRpcRequest;
import net.apexes.wsonrpc.core.message.JsonRpcResponse;
import net.apexes.wsonrpc.json.JsonImplementor;

public abstract class JsonRpcMessage {
    protected final String id;

    protected JsonRpcMessage(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public abstract String toJson(JsonImplementor var1) throws Exception;

    public static JsonRpcMessage of(JsonImplementor jsonImpl, String json) throws Exception {
        JsonImplementor.Node node = jsonImpl.fromJson(json);
        String id = null;
        if (node.has("id")) {
            id = node.getString("id");
        }
        if (node.has("method")) {
            String method = node.getString("method");
            JsonImplementor.Node[] params = node.has("params") ? node.getArray("params") : new JsonImplementor.Node[]{};
            return new JsonRpcRequest(id, method, params);
        }
        if (node.has("error")) {
            JsonImplementor.Node error = node.get("error");
            Integer code = error.getInteger("code");
            String message = error.getString("message");
            String data = null;
            if (error.has("data")) {
                data = jsonImpl.toJson(error.get("data"));
            }
            return new JsonRpcResponse(id, new JsonRpcError(code, message, data));
        }
        if (node.has("result")) {
            JsonImplementor.Node result = node.get("result");
            return new JsonRpcResponse(id, result);
        }
        return null;
    }
}

