/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.message;

import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.json.JsonImplementor;

public class JsonRpcRequest
extends JsonRpcMessage {
    private final String method;
    private final JsonImplementor.Node[] params;

    public JsonRpcRequest(String id, String method, JsonImplementor.Node[] params) {
        super(id);
        if (method == null) {
            throw new NullPointerException("method");
        }
        this.method = method;
        this.params = params;
    }

    public String getMethod() {
        return this.method;
    }

    public JsonImplementor.Node[] getParams() {
        return this.params;
    }

    public boolean isNotice() {
        return this.id == null;
    }

    @Override
    public String toJson(JsonImplementor jsonImpl) throws Exception {
        JsonImplementor.Node req = jsonImpl.createNode();
        req.put("jsonrpc", "2.0");
        req.put("method", this.method);
        if (this.params != null && this.params.length > 0) {
            req.put("params", this.params);
        }
        if (this.id != null) {
            req.put("id", this.id);
        }
        return jsonImpl.toJson(req);
    }
}

