/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.message;

import net.apexes.wsonrpc.core.message.JsonRpcError;
import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.json.JsonImplementor;

public class JsonRpcResponse
extends JsonRpcMessage {
    private final JsonImplementor.Node result;
    private final JsonRpcError error;

    public JsonRpcResponse(String id, JsonImplementor.Node result) {
        super(id);
        if (id == null) {
            throw new NullPointerException("id");
        }
        this.result = result;
        this.error = null;
    }

    public JsonRpcResponse(String id, JsonRpcError error) {
        super(id);
        if (error == null) {
            throw new NullPointerException("error");
        }
        this.error = error;
        this.result = null;
    }

    public JsonImplementor.Node getResult() {
        return this.result;
    }

    public JsonRpcError getError() {
        return this.error;
    }

    @Override
    public String toJson(JsonImplementor jsonImpl) throws Exception {
        JsonImplementor.Node resp = jsonImpl.createNode();
        resp.put("jsonrpc", "2.0");
        if (this.id != null) {
            resp.put("id", this.id);
        }
        if (this.error != null) {
            JsonImplementor.Node errorNode = jsonImpl.createNode();
            errorNode.put("code", this.error.getCode());
            errorNode.put("message", this.error.getMessage());
            if (this.error.getData() != null) {
                errorNode.put("data", this.error.getData());
            }
            resp.put("error", errorNode);
        } else if (this.result != null) {
            resp.put("result", this.result);
        }
        return jsonImpl.toJson(resp);
    }
}

