/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import net.apexes.wsonrpc.json.JsonImplementor;

public class JacksonImplementor
implements JsonImplementor {
    private final ObjectMapper objectMapper;

    public JacksonImplementor() {
        this(new ObjectMapper());
    }

    public JacksonImplementor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public JsonImplementor.Node fromJson(String json) throws Exception {
        return new JacksonNode(this.objectMapper.readTree(json));
    }

    @Override
    public String toJson(JsonImplementor.Node node) throws Exception {
        JacksonNode jacksonNode = (JacksonNode)node;
        return this.objectMapper.writeValueAsString((Object)jacksonNode.jsonNode);
    }

    @Override
    public JsonImplementor.Node createNode() {
        JsonNodeFactory factory = new JsonNodeFactory(false);
        return new JacksonNode((JsonNode)factory.objectNode());
    }

    @Override
    public boolean isCompatible(JsonImplementor.Node node, Class<?> classType) {
        return true;
    }

    @Override
    public <T> T convert(JsonImplementor.Node node, Class<T> classType) {
        JacksonNode jacksonNode = (JacksonNode)node;
        return (T)this.objectMapper.convertValue((Object)jacksonNode.jsonNode, classType);
    }

    @Override
    public JsonImplementor.Node convert(Object object) {
        return new JacksonNode(this.objectMapper.valueToTree(object));
    }

    private static class JacksonNode
    implements JsonImplementor.Node {
        private final JsonNode jsonNode;

        public JacksonNode(JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public boolean has(String name) {
            return this.jsonNode.has(name);
        }

        @Override
        public JsonImplementor.Node get(String name) {
            return new JacksonNode(this.jsonNode.get(name));
        }

        @Override
        public Integer getInteger(String name) {
            return this.jsonNode.get(name).asInt();
        }

        @Override
        public String getString(String name) {
            return this.jsonNode.get(name).asText();
        }

        @Override
        public JsonImplementor.Node[] getArray(String name) {
            JsonNode paramNode = this.jsonNode.get(name);
            int size = paramNode.size();
            JsonImplementor.Node[] results = new JsonImplementor.Node[size];
            for (int i = 0; i < size; ++i) {
                results[i] = new JacksonNode(paramNode.get(i));
            }
            return results;
        }

        @Override
        public void put(String name, int value) {
            if (!(this.jsonNode instanceof ObjectNode)) {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            ObjectNode objectNode = (ObjectNode)this.jsonNode;
            objectNode.put(name, value);
        }

        @Override
        public void put(String name, String value) {
            if (!(this.jsonNode instanceof ObjectNode)) {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            ObjectNode objectNode = (ObjectNode)this.jsonNode;
            objectNode.put(name, value);
        }

        @Override
        public void put(String name, JsonImplementor.Node value) {
            ObjectNode objectNode;
            if (this.jsonNode instanceof ObjectNode) {
                objectNode = (ObjectNode)this.jsonNode;
                if (!(value instanceof JacksonNode)) {
                    throw new UnsupportedOperationException("value must be JacksonNode");
                }
            } else {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            JacksonNode jacksonNode = (JacksonNode)value;
            objectNode.set(name, jacksonNode.jsonNode);
        }

        @Override
        public void put(String name, JsonImplementor.Node[] array) {
            ArrayNode arrayNode;
            ObjectNode objectNode;
            if (this.jsonNode instanceof ObjectNode) {
                objectNode = (ObjectNode)this.jsonNode;
                arrayNode = objectNode.arrayNode();
                for (int i = 0; i < array.length; ++i) {
                    if (!(array[i] instanceof JacksonNode)) {
                        throw new UnsupportedOperationException("array[" + i + "] must be JacksonNode");
                    }
                    JacksonNode jacksonNode = (JacksonNode)array[i];
                    arrayNode.add(jacksonNode.jsonNode);
                }
            } else {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            objectNode.set(name, (JsonNode)arrayNode);
        }

        public String toString() {
            return this.jsonNode.toString();
        }
    }
}

