/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.core.RemoteException;
import net.apexes.wsonrpc.core.ServiceHolder;
import net.apexes.wsonrpc.core.ServiceMethodInvoker;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.Transport;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.message.JsonRpcError;
import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.core.message.JsonRpcRequest;
import net.apexes.wsonrpc.core.message.JsonRpcResponse;
import net.apexes.wsonrpc.json.JsonImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcEngine.class);
    private final JsonImplementor jsonImpl;
    private final BinaryWrapper binaryWrapper;
    private final ServiceRegistry serviceRegistry;

    public JsonRpcEngine(JsonImplementor jsonImpl) {
        this(jsonImpl, null);
    }

    protected JsonRpcEngine(JsonImplementor jsonImpl, BinaryWrapper binaryWrapper) {
        if (jsonImpl == null) {
            throw new NullPointerException("jsonImpl");
        }
        this.jsonImpl = jsonImpl;
        this.binaryWrapper = binaryWrapper;
        this.serviceRegistry = new ServiceRegistry();
    }

    protected JsonImplementor getJsonImplementor() {
        return this.jsonImpl;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public void receiveRequest(byte[] bytes, Transport transport) throws IOException, WsonrpcException {
        JsonRpcResponse resp;
        try {
            JsonRpcMessage msg = this.receive(bytes);
            if (msg instanceof JsonRpcRequest) {
                JsonRpcRequest req = (JsonRpcRequest)msg;
                resp = this.execute(req);
            } else {
                resp = new JsonRpcResponse(null, JsonRpcError.invalidRequestError(null));
            }
        }
        catch (JsonException e) {
            resp = new JsonRpcResponse(null, JsonRpcError.parseError(e));
        }
        catch (IOException e) {
            resp = new JsonRpcResponse(null, JsonRpcError.internalError(e));
        }
        this.transmit(transport, resp);
    }

    public <T> T receiveResponse(byte[] bytes, Class<T> returnType) throws IOException, WsonrpcException, RemoteException {
        JsonRpcMessage msg;
        try {
            msg = this.receive(bytes);
        }
        catch (JsonException e) {
            throw new WsonrpcException("parse response error", e);
        }
        if (msg instanceof JsonRpcResponse) {
            return this.convertResponse((JsonRpcResponse)msg, returnType);
        }
        throw new WsonrpcException("invalid response");
    }

    public void invoke(String serviceName, String methodName, Object[] args, String id, Transport transport) throws IOException, WsonrpcException {
        if (methodName == null) {
            throw new NullPointerException("methodName");
        }
        String method = serviceName == null ? methodName : serviceName + "." + methodName;
        JsonImplementor.Node[] params = null;
        if (args != null) {
            params = new JsonImplementor.Node[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = this.jsonImpl.convert(args[i]);
            }
        }
        this.transmit(transport, new JsonRpcRequest(id, method, params));
    }

    protected JsonRpcResponse execute(JsonRpcRequest request) {
        ServiceHolder holder;
        if (request == null) {
            return new JsonRpcResponse(null, JsonRpcError.parseError(null));
        }
        String id = request.getId();
        String serviceMethod = request.getMethod();
        String serviceName = null;
        String methodName = serviceMethod;
        int lastIndex = serviceMethod.lastIndexOf(46);
        if (lastIndex >= 0) {
            serviceName = serviceMethod.substring(0, lastIndex);
            methodName = serviceMethod.substring(lastIndex + 1);
        }
        if ((holder = this.serviceRegistry.getServiceHolder(serviceName)) == null) {
            return new JsonRpcResponse(id, JsonRpcError.methodNotFoundError(null));
        }
        ServiceMethodInvoker invoker = holder.findInvoker(serviceName, methodName);
        if (invoker == null) {
            return new JsonRpcResponse(id, JsonRpcError.methodNotFoundError(null));
        }
        JsonImplementor.Node[] params = request.getParams();
        if (invoker.validateParameters(this.jsonImpl, params)) {
            try {
                Object invokeValue = invoker.invoke();
                if (id == null) {
                    return null;
                }
                JsonImplementor.Node result = this.jsonImpl.convert(invokeValue);
                return new JsonRpcResponse(id, result);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                LOG.debug("executing error : " + serviceMethod, t);
                return new JsonRpcResponse(id, JsonRpcError.serverError(2, "Server error", t));
            }
        }
        return new JsonRpcResponse(id, JsonRpcError.invalidParamsError(null));
    }

    protected <T> T convertResponse(JsonRpcResponse resp, Class<T> returnType) throws WsonrpcException, RemoteException {
        if (resp.getError() != null) {
            throw new RemoteException(resp.getError());
        }
        if (resp.getResult() == null) {
            return null;
        }
        try {
            return this.jsonImpl.convert(resp.getResult(), returnType);
        }
        catch (Throwable t) {
            throw new WsonrpcException(t.getMessage(), t);
        }
    }

    protected void transmit(Transport transport, JsonRpcMessage message) throws IOException, WsonrpcException {
        String json;
        try {
            json = message.toJson(this.jsonImpl);
        }
        catch (Exception e) {
            throw new WsonrpcException("serialize error", e);
        }
        LOG.debug(" >>  {}", (Object)json);
        byte[] bytes = json.getBytes("UTF-8");
        if (this.binaryWrapper != null) {
            LOG.debug(" = {}", (Object)bytes.length);
            bytes = this.binaryWrapper.write(bytes);
            LOG.debug(" - {}", (Object)bytes.length);
        }
        transport.sendBinary(bytes);
    }

    protected JsonRpcMessage receive(byte[] bytes) throws IOException, JsonException {
        if (this.binaryWrapper != null) {
            LOG.debug(" - {}", (Object)bytes.length);
            bytes = this.binaryWrapper.read(bytes);
            LOG.debug(" = {}", (Object)bytes.length);
        }
        String json = new String(bytes, "UTF-8");
        LOG.debug(" <<  {}", (Object)json);
        return JsonRpcMessage.of(this.jsonImpl, json);
    }
}

