/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.PrintStream;
import net.apexes.wsonrpc.core.message.JsonRpcError;

public class RemoteException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final JsonRpcError error;

    public RemoteException(JsonRpcError error) {
        super(RemoteException.formatMessage(error));
        this.error = error;
        this.printStackTrace();
    }

    public JsonRpcError getJsonRpcError() {
        return this.error;
    }

    @Override
    public void printStackTrace(PrintStream s) {
        if (this.error.getData() != null) {
            String data = this.error.getData();
            data = data.replace("\\r", "\r").replace("\\n", "\n").replace("\\t", "\t");
            s.print(data);
        }
    }

    private static String formatMessage(JsonRpcError error) {
        StringBuilder str = new StringBuilder();
        if (error.getCode() != null) {
            str.append("[").append(error.getCode()).append("]");
        }
        if (error.getMessage() != null) {
            str.append(" ");
            str.append(error.getMessage());
        }
        return str.toString();
    }
}

