/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import net.apexes.wsonrpc.core.Remote;

public final class RemoteInvoker {
    private final Remote remote;
    private String serviceName;
    private ClassLoader classLoader;
    private int timeout;

    public static RemoteInvoker create(Remote remote) {
        return new RemoteInvoker(remote);
    }

    private RemoteInvoker(Remote remote) {
        this.remote = remote;
    }

    public RemoteInvoker serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public RemoteInvoker classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public RemoteInvoker timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public <T> T get(Class<T> serviceClass) {
        if (this.classLoader == null) {
            this.classLoader = serviceClass.getClassLoader();
        }
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (method.getDeclaringClass() == Object.class) {
                    return RemoteInvoker.proxyObjectMethods(method, proxy, args);
                }
                Class<?> returnType = method.getReturnType();
                if (returnType == Void.TYPE) {
                    RemoteInvoker.this.remote.invoke(RemoteInvoker.this.serviceName, method.getName(), args);
                    return null;
                }
                return RemoteInvoker.this.remote.invoke(RemoteInvoker.this.serviceName, method.getName(), args, returnType, RemoteInvoker.this.timeout);
            }
        };
        return (T)Proxy.newProxyInstance(this.classLoader, new Class[]{serviceClass}, handler);
    }

    private static Object proxyObjectMethods(Method method, Object proxyObject, Object[] args) {
        String name = method.getName();
        if (name.equals("toString")) {
            return proxyObject.getClass().getName() + "@" + System.identityHashCode(proxyObject);
        }
        if (name.equals("hashCode")) {
            return System.identityHashCode(proxyObject);
        }
        if (name.equals("equals")) {
            return proxyObject == args[0];
        }
        throw new RuntimeException(method.getName() + " is not a member of java.lang.Object");
    }
}

