/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.apexes.wsonrpc.core.ServiceHolder;
import net.apexes.wsonrpc.core.support.ReflectServiceHolder;

public class ServiceRegistry {
    private final ConcurrentMap<String, ServiceHolder> services = new ConcurrentHashMap<String, ServiceHolder>();

    public <T> ServiceRegistry register(String name, ServiceHolder serviceHolder) {
        if (this.services.containsKey(name)) {
            throw new IllegalArgumentException("service already exists");
        }
        this.services.put(name, serviceHolder);
        return this;
    }

    public <T> ServiceRegistry register(String name, T service, Class<?> ... classes) {
        if (this.services.containsKey(name)) {
            throw new IllegalArgumentException("service already exists");
        }
        return this.register(name, new ReflectServiceHolder<T>(service, classes));
    }

    public ServiceRegistry unregister(String name) {
        this.services.remove(name);
        return this;
    }

    ServiceHolder getServiceHolder(String serviceName) {
        return (ServiceHolder)this.services.get(serviceName);
    }
}

