/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcErrorProcessor;
import net.apexes.wsonrpc.core.WsonrpcInterceptor;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.support.GsonImplementor;

public final class WsonrpcConfigBuilder {
    private JsonImplementor jsonImpl;
    private BinaryWrapper binaryWrapper;
    private WsonrpcInterceptor interceptor;
    private WsonrpcErrorProcessor errorProcessor;

    public static WsonrpcConfig defaultConfig() {
        return WsonrpcConfigBuilder.create().build();
    }

    public static WsonrpcConfigBuilder create() {
        return new WsonrpcConfigBuilder();
    }

    private WsonrpcConfigBuilder() {
    }

    public WsonrpcConfig build() {
        if (this.jsonImpl == null) {
            this.jsonImpl = new GsonImplementor();
        }
        return new WsonrpcConfigImpl(this.jsonImpl, this.binaryWrapper, this.interceptor, this.errorProcessor);
    }

    public WsonrpcConfigBuilder json(JsonImplementor jsonImpl) {
        this.jsonImpl = jsonImpl;
        return this;
    }

    public WsonrpcConfigBuilder binaryWrapper(BinaryWrapper binaryWrapper) {
        this.binaryWrapper = binaryWrapper;
        return this;
    }

    public WsonrpcConfigBuilder interceptor(WsonrpcInterceptor interceptor) {
        this.interceptor = interceptor;
        return this;
    }

    public WsonrpcConfigBuilder errorProcessor(WsonrpcErrorProcessor errorProcessor) {
        this.errorProcessor = errorProcessor;
        return this;
    }

    static class WsonrpcConfigImpl
    implements WsonrpcConfig {
        private final JsonImplementor jsonImpl;
        private final BinaryWrapper binaryWrapper;
        private final WsonrpcInterceptor interceptor;
        private final WsonrpcErrorProcessor errorProcessor;

        private WsonrpcConfigImpl(JsonImplementor jsonImpl, BinaryWrapper binaryWrapper, WsonrpcInterceptor interceptor, WsonrpcErrorProcessor errorProcessor) {
            this.jsonImpl = jsonImpl;
            this.binaryWrapper = binaryWrapper;
            this.interceptor = interceptor;
            this.errorProcessor = errorProcessor;
        }

        @Override
        public JsonImplementor getJsonImplementor() {
            return this.jsonImpl;
        }

        @Override
        public BinaryWrapper getBinaryWrapper() {
            return this.binaryWrapper;
        }

        @Override
        public WsonrpcInterceptor getWsonrpcInterceptor() {
            return this.interceptor;
        }

        @Override
        public WsonrpcErrorProcessor getErrorProcessor() {
            return this.errorProcessor;
        }
    }
}

