/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.apexes.wsonrpc.core.Futures;
import net.apexes.wsonrpc.core.RemoteException;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcEngine;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.WsonrpcFuture;
import net.apexes.wsonrpc.core.WsonrpcRemote;

public class WsonrpcEndpoint
implements WsonrpcRemote {
    protected final WsonrpcEngine wsonrpcEngine;
    private WebSocketSession session;

    protected WsonrpcEndpoint(WsonrpcConfig config) {
        this.wsonrpcEngine = new WsonrpcEngine(config);
    }

    protected final void online(WebSocketSession session) {
        this.session = session;
    }

    protected final void offline() {
        try {
            this.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected WebSocketSession getSession() {
        return this.session;
    }

    protected void verifyOnline() throws WsonrpcException {
        if (!this.isConnected()) {
            throw new WsonrpcException("Connection is closed.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public String getSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    @Override
    public void disconnect() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    @Override
    public void ping() throws Exception {
        this.verifyOnline();
        this.session.ping();
    }

    @Override
    public void invoke(String serviceName, String methodName, Object[] args) throws IOException, WsonrpcException {
        this.verifyOnline();
        this.wsonrpcEngine.invoke(this.getSession(), serviceName, methodName, args);
    }

    @Override
    public <T> T invoke(String serviceName, String methodName, Object[] args, Class<T> returnType, int timeout) throws IOException, WsonrpcException, RemoteException {
        WsonrpcFuture<T> future = this.invoke(this.getSession(), serviceName, methodName, args, returnType);
        try {
            if (timeout <= 0) {
                return future.get();
            }
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            Futures.out(future.idKey);
            if (e instanceof ExecutionException) {
                e = e.getCause();
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            if (e instanceof WsonrpcException) {
                throw (WsonrpcException)e;
            }
            throw new WsonrpcException(e);
        }
    }

    @Override
    public <T> Future<T> asyncInvoke(String serviceName, String methodName, Object[] args, Class<T> returnType) throws IOException, WsonrpcException {
        this.verifyOnline();
        return this.invoke(this.getSession(), serviceName, methodName, args, returnType);
    }

    private <T> WsonrpcFuture<T> invoke(WebSocketSession session, String serviceName, String methodName, Object[] args, Class<T> returnType) throws IOException, WsonrpcException {
        return this.wsonrpcEngine.invoke(session, serviceName, methodName, args, returnType);
    }
}

