/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.util.UUID;
import net.apexes.wsonrpc.core.Futures;
import net.apexes.wsonrpc.core.JsonRpcEngine;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.WsonrpcFuture;
import net.apexes.wsonrpc.core.WsonrpcInterceptor;
import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.core.message.JsonRpcRequest;
import net.apexes.wsonrpc.core.message.JsonRpcResponse;

public class WsonrpcEngine {
    private final WsonrpcConfig config;
    private final JsonRpcEngine jsonRpcEngine;

    public WsonrpcEngine(WsonrpcConfig config) {
        this.config = config;
        this.jsonRpcEngine = new JsonRpcEngine(config.getJsonImplementor());
    }

    public final WsonrpcConfig getConfig() {
        return this.config;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.jsonRpcEngine.getServiceRegistry();
    }

    public WsonrpcFuture<Object> invoke(WebSocketSession session, String serviceName, String methodName, Object[] args, Class<?> returnType) throws IOException, WsonrpcException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        String id = UUID.randomUUID().toString().replaceAll("-", "");
        WsonrpcFuture<Object> future = new WsonrpcFuture<Object>(id, returnType);
        Futures.put(future);
        try {
            this.jsonRpcEngine.invoke(serviceName, methodName, args, id, session);
            return future;
        }
        catch (Throwable t) {
            Futures.out(id);
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof WsonrpcException) {
                throw (WsonrpcException)t;
            }
            throw new WsonrpcException(t);
        }
    }

    public void invoke(WebSocketSession session, String serviceName, String methodName, Object[] args) throws IOException, WsonrpcException {
        if (session == null) {
            throw new NullPointerException("session");
        }
        this.jsonRpcEngine.invoke(serviceName, methodName, args, null, session);
    }

    public void handle(WebSocketSession session, byte[] bytes) {
        if (session == null) {
            throw new NullPointerException("session");
        }
        try {
            JsonRpcMessage msg = this.jsonRpcEngine.receive(bytes);
            if (msg instanceof JsonRpcRequest) {
                this.handleRequest(session, (JsonRpcRequest)msg);
            } else if (msg instanceof JsonRpcResponse) {
                this.handleResponse(session, (JsonRpcResponse)msg);
            }
        }
        catch (Exception e) {
            this.config.getErrorProcessor().onError(session.getId(), e);
        }
    }

    protected void handleRequest(WebSocketSession session, JsonRpcRequest request) {
        if (this.config.getWsonrpcInterceptor() == null || request == null) {
            this.exec(session, request);
        } else {
            String method = request.getMethod();
            this.config.getWsonrpcInterceptor().onHandleRequest(new ContextImpl(session, request), method);
        }
    }

    protected void handleResponse(WebSocketSession session, JsonRpcResponse response) {
        String id = response.getId();
        if (id == null) {
            return;
        }
        WsonrpcFuture<Object> future = Futures.out(id);
        try {
            Object value = this.jsonRpcEngine.convertResponse(response, future.returnType);
            future.set(value);
        }
        catch (Throwable t) {
            future.setException(t);
        }
    }

    private void exec(WebSocketSession session, JsonRpcRequest request) {
        block3: {
            try {
                JsonRpcResponse resp = this.jsonRpcEngine.execute(request);
                if (resp != null) {
                    this.jsonRpcEngine.transmit(session, resp);
                }
            }
            catch (Exception e) {
                if (this.config.getErrorProcessor() == null) break block3;
                this.config.getErrorProcessor().onError(session.getId(), e);
            }
        }
    }

    private class ContextImpl
    implements WsonrpcInterceptor.Context {
        private final WebSocketSession session;
        private final JsonRpcRequest request;

        private ContextImpl(WebSocketSession session, JsonRpcRequest request) {
            this.session = session;
            this.request = request;
        }

        @Override
        public void execute() {
            WsonrpcEngine.this.exec(this.session, this.request);
        }
    }
}

