/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.apexes.wsonrpc.core.Futures;
import net.apexes.wsonrpc.core.WsonrpcIdKey;
import net.apexes.wsonrpc.util.AbstractFuture;

class WsonrpcFuture<V>
extends AbstractFuture<V> {
    final WsonrpcIdKey idKey;
    final Class<?> returnType;

    WsonrpcFuture(String id, Class<?> returnType) {
        if (id == null) {
            throw new NullPointerException("id");
        }
        if (returnType == null) {
            throw new NullPointerException("returnType");
        }
        this.idKey = new WsonrpcIdKey.StringIdKey(id);
        this.returnType = returnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        try {
            Object v = super.get(timeout, unit);
            return v;
        }
        finally {
            Futures.out(this.idKey);
        }
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        try {
            Object v = super.get();
            return v;
        }
        finally {
            Futures.out(this.idKey);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            boolean bl = super.cancel(mayInterruptIfRunning);
            return bl;
        }
        finally {
            Futures.out(this.idKey);
        }
    }

    @Override
    public boolean set(V value) {
        return super.set(value);
    }

    @Override
    public boolean setException(Throwable throwable) {
        return super.setException(throwable);
    }
}

