/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.message;

import java.io.PrintWriter;
import java.io.StringWriter;

public class JsonRpcError {
    private final Integer code;
    private final String message;
    private final String data;

    public JsonRpcError(Integer code, String message, String data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getData() {
        return this.data;
    }

    public static JsonRpcError parseError(Throwable t) {
        return new JsonRpcError(-32700, "Parse error", JsonRpcError.getStackTrace(t));
    }

    public static JsonRpcError invalidRequestError(Throwable t) {
        return new JsonRpcError(-32600, "Invalid Request", JsonRpcError.getStackTrace(t));
    }

    public static JsonRpcError methodNotFoundError(Throwable t) {
        return new JsonRpcError(-32601, "Method not found", JsonRpcError.getStackTrace(t));
    }

    public static JsonRpcError invalidParamsError(Throwable t) {
        return new JsonRpcError(-32602, "Invalid params", JsonRpcError.getStackTrace(t));
    }

    public static JsonRpcError internalError(Throwable t) {
        return new JsonRpcError(-32603, "Internal error", JsonRpcError.getStackTrace(t));
    }

    public static JsonRpcError serverError(int index, String msg, Throwable t) {
        return new JsonRpcError(-32000 - index, msg, JsonRpcError.getStackTrace(t));
    }

    static String getStackTrace(Throwable t) {
        if (t == null) {
            return null;
        }
        StringWriter strWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(strWriter);
        t.printStackTrace(writer);
        writer.close();
        return strWriter.toString();
    }
}

