/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.support;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.apexes.wsonrpc.core.ServiceHolder;
import net.apexes.wsonrpc.core.ServiceMethodInvoker;
import net.apexes.wsonrpc.core.support.ReflectServiceMethodInvoker;

public class ReflectServiceHolder<T>
implements ServiceHolder {
    private final T service;
    private final Map<String, Set<Method>> methodFinder;

    public ReflectServiceHolder(T service, Class<?> ... classes) {
        if (service == null) {
            throw new NullPointerException("service");
        }
        if (classes.length == 0) {
            throw new IllegalArgumentException("none interface");
        }
        this.service = service;
        HashMap<String, HashSet<Method>> map = new HashMap<String, HashSet<Method>>();
        Class<?> serviceClass = service.getClass();
        for (Class<?> clazz : classes) {
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("class should be an interface : " + clazz);
            }
            for (Method m : clazz.getMethods()) {
                Method method;
                String methodName = m.getName();
                Class<?>[] params = m.getParameterTypes();
                try {
                    method = serviceClass.getMethod(methodName, params);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalArgumentException("not implements method : " + methodName + ReflectServiceHolder.argumentTypesToString(params));
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("access error : " + methodName + ReflectServiceHolder.argumentTypesToString(params), e);
                }
                HashSet<Method> set = (HashSet<Method>)map.get(methodName);
                if (set == null) {
                    set = new HashSet<Method>();
                    map.put(methodName, set);
                }
                set.add(method);
            }
        }
        this.methodFinder = Collections.unmodifiableMap(map);
    }

    @Override
    public ServiceMethodInvoker findInvoker(String serviceName, String methodName) {
        Set<Method> methods = this.methodFinder.get(methodName);
        if (methods == null) {
            return null;
        }
        return new ReflectServiceMethodInvoker(this.service, methods);
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

