/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.support;

import java.lang.reflect.Method;
import java.util.Set;
import net.apexes.wsonrpc.core.ServiceMethodInvoker;
import net.apexes.wsonrpc.json.JsonImplementor;

public class ReflectServiceMethodInvoker
implements ServiceMethodInvoker {
    private final Object service;
    private final Set<Method> methods;
    private Method method;
    private Object[] args;

    ReflectServiceMethodInvoker(Object service, Set<Method> methods) {
        this.service = service;
        this.methods = methods;
    }

    @Override
    public boolean validateParameters(JsonImplementor jsonImpl, JsonImplementor.Node[] params) {
        this.args = null;
        this.method = ReflectServiceMethodInvoker.findMethod(this.methods, jsonImpl, params);
        if (this.method == null) {
            return false;
        }
        this.args = ReflectServiceMethodInvoker.getArgs(jsonImpl, this.method, params);
        return true;
    }

    @Override
    public Object invoke() throws Exception {
        return this.method.invoke(this.service, this.args);
    }

    private static Method findMethod(Set<Method> methods, JsonImplementor jsonImpl, JsonImplementor.Node[] params) {
        if (params == null) {
            for (Method method : methods) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length != 0) continue;
                return method;
            }
        } else {
            for (Method method : methods) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length != params.length) continue;
                boolean compatible = true;
                for (int i = 0; i < types.length; ++i) {
                    if (jsonImpl.isCompatible(params[i], types[i])) continue;
                    compatible = false;
                    break;
                }
                if (!compatible) continue;
                return method;
            }
        }
        return null;
    }

    private static Object[] getArgs(JsonImplementor jsonImpl, Method method, JsonImplementor.Node[] params) {
        Object[] args = new Object[params.length];
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            JsonImplementor.Node node = params[i];
            args[i] = jsonImpl.convert(node, types[i]);
        }
        return args;
    }
}

