/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.Reader;
import java.io.StringReader;
import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.json.JsonImplementor;

public class GsonImplementor
implements JsonImplementor {
    private final Gson gson;

    public GsonImplementor() {
        this(new Gson());
    }

    public GsonImplementor(Gson gson) {
        this.gson = gson;
    }

    @Override
    public JsonImplementor.Node fromJson(String json) throws JsonException {
        JsonParser parser = new JsonParser();
        JsonElement jsonElement = parser.parse((Reader)new StringReader(json));
        return new GsonNode(jsonElement);
    }

    @Override
    public String toJson(JsonImplementor.Node node) throws JsonException {
        GsonNode gsonNode = (GsonNode)node;
        return gsonNode.toString();
    }

    @Override
    public JsonImplementor.Node createNode() {
        return new GsonNode((JsonElement)new JsonObject());
    }

    @Override
    public boolean isCompatible(JsonImplementor.Node node, Class<?> classType) {
        return true;
    }

    @Override
    public <T> T convert(JsonImplementor.Node node, Class<T> classType) {
        GsonNode gsonNode = (GsonNode)node;
        return (T)this.gson.fromJson(gsonNode.jsonElement, classType);
    }

    @Override
    public JsonImplementor.Node convert(Object object) {
        JsonElement jsonElement = this.gson.toJsonTree(object);
        return new GsonNode(jsonElement);
    }

    private static class GsonNode
    implements JsonImplementor.Node {
        private final JsonElement jsonElement;
        private final JsonObject jsonObject;

        public GsonNode(JsonElement jsonElement) {
            this.jsonElement = jsonElement;
            this.jsonObject = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        }

        @Override
        public boolean has(String name) {
            if (this.jsonObject == null) {
                return false;
            }
            return this.jsonObject.has(name);
        }

        @Override
        public JsonImplementor.Node get(String name) {
            if (this.jsonObject == null) {
                return null;
            }
            return new GsonNode(this.jsonObject.get(name));
        }

        @Override
        public Integer getInteger(String name) {
            if (this.jsonObject == null) {
                return null;
            }
            JsonElement je = this.jsonObject.get(name);
            if (je.isJsonNull()) {
                return null;
            }
            return je.getAsInt();
        }

        @Override
        public String getString(String name) {
            if (this.jsonObject == null) {
                return null;
            }
            JsonElement je = this.jsonObject.get(name);
            if (je.isJsonNull()) {
                return null;
            }
            return je.getAsString();
        }

        @Override
        public JsonImplementor.Node[] getArray(String name) {
            if (this.jsonObject == null) {
                return null;
            }
            JsonElement je = this.jsonObject.get(name);
            if (je.isJsonNull()) {
                return new JsonImplementor.Node[0];
            }
            JsonArray jsonArray = je.getAsJsonArray();
            int size = jsonArray.size();
            JsonImplementor.Node[] results = new JsonImplementor.Node[size];
            for (int i = 0; i < size; ++i) {
                results[i] = new GsonNode(jsonArray.get(i));
            }
            return results;
        }

        @Override
        public void put(String name, int value) {
            if (this.jsonObject == null) {
                throw new UnsupportedOperationException();
            }
            this.jsonObject.addProperty(name, (Number)value);
        }

        @Override
        public void put(String name, String value) {
            if (this.jsonObject == null) {
                throw new UnsupportedOperationException();
            }
            this.jsonObject.addProperty(name, value);
        }

        @Override
        public void put(String name, JsonImplementor.Node value) {
            if (this.jsonObject == null) {
                throw new UnsupportedOperationException();
            }
            if (!(value instanceof GsonNode)) {
                throw new UnsupportedOperationException("value must be GsonNode");
            }
            GsonNode gsonNode = (GsonNode)value;
            this.jsonObject.add(name, gsonNode.jsonElement);
        }

        @Override
        public void put(String name, JsonImplementor.Node[] array) {
            if (this.jsonObject == null) {
                throw new UnsupportedOperationException();
            }
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < array.length; ++i) {
                if (!(array[i] instanceof GsonNode)) {
                    throw new UnsupportedOperationException("array[" + i + "] must be GsonNode");
                }
                GsonNode gsonNode = (GsonNode)array[i];
                jsonArray.add(gsonNode.jsonElement);
            }
            this.jsonObject.add(name, (JsonElement)jsonArray);
        }

        public String toString() {
            return this.jsonElement.toString();
        }
    }
}

