/*
 * Copyright (c) 2017, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.wsonrpc.core;

import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonNode;

import java.lang.reflect.Method;
import java.util.Set;

/**
 * @author <a href=mailto:hedyn@foxmail.com>HeDYn</a>
 */
class ReflectServiceMethodInvoker {

    private final Object instance;
    private final Set<Method> methods;
    private Method method;
    private Object[] args;

    ReflectServiceMethodInvoker(Object instance, Set<Method> methods) {
        this.instance = instance;
        this.methods = methods;
    }

    boolean validateParameters(JsonImplementor jsonImpl, JsonNode[] params) {
        args = null;
        method = null;
        for (Method m : methods) {
            if (isCompatible(jsonImpl, m.getParameterTypes(), params)) {
                method = m;
                break;
            }
        }
        if (method == null) {
            return false;
        }
        args = getArgs(jsonImpl, method.getParameterTypes(), params);
        return true;
    }

    Object invoke() throws Exception {
        return method.invoke(instance, args);
    }

    static boolean isCompatible(JsonImplementor jsonImpl, Class<?>[] types, JsonNode[] params) {
        if (types.length != params.length) {
            return false;
        }
        for (int i = 0; i < types.length; i++) {
            if (!jsonImpl.isCompatible(params[i], types[i])) {
                return false;
            }
        }
        return true;
    }

    static Object[] getArgs(JsonImplementor jsonImpl, Class<?>[] types, JsonNode[] params) {
        if (types.length != params.length) {
            throw new IllegalArgumentException();
        }
        Object[] args = new Object[params.length];
        for (int i = 0; i < types.length; i++) {
            JsonNode node = params[i];
            args[i] = jsonImpl.convert(node, types[i]);
        }
        return args;
    }
}
