/*
 * Copyright (C) 2016, apexes.net. All rights reserved.
 * 
 *        http://www.apexes.net
 * 
 */
package net.apexes.wsonrpc.core;

import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.support.GsonImplementor;

/**
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 */
public class WsonrpcConfigBuilder {

    public static WsonrpcConfig defaultConfig() {
        return create().build();
    }

    public static WsonrpcConfigBuilder create() {
        return new WsonrpcConfigBuilder();
    }

    private JsonImplementor jsonImpl;
    private BinaryWrapper binaryWrapper;
    private WsonrpcLogger wsonrpcLogger;

    protected WsonrpcConfigBuilder() {
    }

    public WsonrpcConfig build() {
        if (jsonImpl == null) {
            jsonImpl = new GsonImplementor();
        }
        return new WsonrpcConfigImpl(jsonImpl, binaryWrapper, wsonrpcLogger);
    }

    /**
     * @param jsonImpl
     * @return
     */
    public WsonrpcConfigBuilder json(JsonImplementor jsonImpl) {
        this.jsonImpl = jsonImpl;
        return this;
    }

    /**
     * @param binaryWrapper
     * @return
     */
    public WsonrpcConfigBuilder wrapper(BinaryWrapper binaryWrapper) {
        this.binaryWrapper = binaryWrapper;
        return this;
    }

    /**
     * @param wsonrpcLogger
     * @return
     */
    public WsonrpcConfigBuilder logger(WsonrpcLogger wsonrpcLogger) {
        this.wsonrpcLogger = wsonrpcLogger;
        return this;
    }

    /**
     *
     */
    protected static class WsonrpcConfigImpl implements WsonrpcConfig {

        private final JsonImplementor jsonImpl;
        private final BinaryWrapper binaryWrapper;
        private final WsonrpcLogger wsonrpcLogger;

        protected WsonrpcConfigImpl(WsonrpcConfig config) {
            this(config.getJsonImplementor(),
                    config.getBinaryWrapper(),
                    config.getWsonrpcLogger());
        }

        protected WsonrpcConfigImpl(JsonImplementor jsonImpl,
                                    BinaryWrapper binaryWrapper,
                                    WsonrpcLogger wsonrpcLogger) {
            this.jsonImpl = jsonImpl;
            this.binaryWrapper = binaryWrapper;
            this.wsonrpcLogger = wsonrpcLogger;
        }

        @Override
        public JsonImplementor getJsonImplementor() {
            return jsonImpl;
        }

        @Override
        public BinaryWrapper getBinaryWrapper() {
            return binaryWrapper;
        }

        @Override
        public WsonrpcLogger getWsonrpcLogger() {
            return wsonrpcLogger;
        }
    }

}
