/*
 * Copyright (C) 2016, apexes.net. All rights reserved.
 * 
 *        http://www.apexes.net
 * 
 */
package net.apexes.wsonrpc.core.message;

import net.apexes.wsonrpc.util.JsonRpcErrors;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public class JsonRpcError {
    
    private final Integer code;
    private final String message;
    private final String data;
    
    public JsonRpcError(Integer code, String message, String data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Integer getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    public String getData() {
        return data;
    }

    public static JsonRpcError parseError() {
        return parseError((Throwable)null);
    }

    public static JsonRpcError parseError(String message) {
        return parseError(message, null);
    }

    public static JsonRpcError parseError(Throwable t) {
        return parseError("Parse error", t);
    }

    public static JsonRpcError parseError(String message, Throwable t) {
        return new JsonRpcError(-32700, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError invalidRequestError() {
        return invalidRequestError((Throwable)null);
    }
    
    public static JsonRpcError invalidRequestError(String message) {
        return invalidRequestError(message, null);
    }

    public static JsonRpcError invalidRequestError(Throwable t) {
        return invalidRequestError("Invalid Requestr", t);
    }

    public static JsonRpcError invalidRequestError(String message, Throwable t) {
        return new JsonRpcError(-32600, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError methodNotFoundError() {
        return methodNotFoundError((Throwable)null);
    }

    public static JsonRpcError methodNotFoundError(String message) {
        return methodNotFoundError(message, null);
    }

    public static JsonRpcError methodNotFoundError(Throwable t) {
        return methodNotFoundError("Method not found", t);
    }

    public static JsonRpcError methodNotFoundError(String message, Throwable t) {
        return new JsonRpcError(-32601, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError invalidParamsError() {
        return invalidParamsError((Throwable)null);
    }
    
    public static JsonRpcError invalidParamsError(String message) {
        return invalidParamsError(message, null);
    }

    public static JsonRpcError invalidParamsError(Throwable t) {
        return invalidParamsError("Invalid params", t);
    }

    public static JsonRpcError invalidParamsError(String message, Throwable t) {
        return new JsonRpcError(-32602, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError internalError() {
        return internalError((Throwable)null);
    }
    
    public static JsonRpcError internalError(String message) {
        return internalError(message, null);
    }

    public static JsonRpcError internalError(Throwable t) {
        return internalError("Internal error", t);
    }

    public static JsonRpcError internalError(String message, Throwable t) {
        return new JsonRpcError(-32603, message, JsonRpcErrors.toJson(t));
    }
    
    public static JsonRpcError serverError(int index, String msg, Throwable t) {
        return new JsonRpcError(-32000 - index, msg, JsonRpcErrors.toJson(t));
    }

}
