/*
 * Copyright (c) 2018, apexes.net. All rights reserved.
 *
 *         http://www.apexes.net
 *
 */
package net.apexes.wsonrpc.json;

/**
 * @author <a href=mailto:hedyn@foxmail.com>HeDYn</a>
 */
public interface JsonNode {

    boolean has(String name);

    JsonNode get(String name);

    Integer getInteger(String name);

    String getString(String name);

    JsonNode[] getArray(String name);

    void put(String name, int value);

    void put(String name, String value);

    void put(String name, JsonNode value);

    void put(String name, JsonNode[] array);

    String toJson();
}
