/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.core.JsonRpcLogger;
import net.apexes.wsonrpc.core.ReflectServiceMethodInvoker;
import net.apexes.wsonrpc.core.RemoteException;
import net.apexes.wsonrpc.core.ServiceRegistry;
import net.apexes.wsonrpc.core.Transport;
import net.apexes.wsonrpc.core.message.JsonRpcError;
import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.core.message.JsonRpcRequest;
import net.apexes.wsonrpc.core.message.JsonRpcResponse;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcEngine {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcEngine.class);
    private final JsonImplementor jsonImpl;
    private final BinaryWrapper binaryWrapper;
    private final ServiceRegistry serviceRegistry;
    private JsonRpcLogger jsonRpcLogger;

    public JsonRpcEngine(JsonImplementor jsonImpl) {
        this(jsonImpl, null);
    }

    public JsonRpcEngine(JsonImplementor jsonImpl, BinaryWrapper binaryWrapper) {
        if (jsonImpl == null) {
            throw new NullPointerException("jsonImpl");
        }
        this.jsonImpl = jsonImpl;
        this.binaryWrapper = binaryWrapper;
        this.serviceRegistry = new ServiceRegistry();
    }

    protected JsonImplementor getJsonImplementor() {
        return this.jsonImpl;
    }

    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    public JsonRpcLogger getJsonRpcLogger() {
        return this.jsonRpcLogger;
    }

    public void setJsonRpcLogger(JsonRpcLogger jsonRpcLogger) {
        this.jsonRpcLogger = jsonRpcLogger;
    }

    public void invoke(String serviceName, String methodName, Object[] args, String id, Transport transport) throws IOException, JsonException {
        this.transmit(transport, this.createRequest(serviceName, methodName, args, id));
    }

    protected JsonRpcRequest createRequest(String serviceName, String methodName, Object[] args, String id) {
        if (methodName == null) {
            throw new NullPointerException("methodName");
        }
        String method = serviceName == null || serviceName.isEmpty() ? methodName : serviceName + "." + methodName;
        JsonNode[] params = null;
        if (args != null) {
            params = new JsonNode[args.length];
            for (int i = 0; i < args.length; ++i) {
                params[i] = this.jsonImpl.convert(args[i]);
            }
        }
        return new JsonRpcRequest(id, method, params);
    }

    public void receiveRequest(byte[] bytes, Transport transport) throws IOException, JsonException {
        JsonRpcResponse resp;
        try {
            JsonRpcMessage msg = this.receive(bytes);
            if (msg instanceof JsonRpcRequest) {
                JsonRpcRequest req = (JsonRpcRequest)msg;
                resp = this.execute(req);
            } else {
                resp = new JsonRpcResponse(null, JsonRpcError.invalidRequestError());
            }
        }
        catch (JsonException e) {
            resp = new JsonRpcResponse(null, JsonRpcError.parseError(e));
        }
        catch (IOException e) {
            resp = new JsonRpcResponse(null, JsonRpcError.internalError(e));
        }
        this.transmit(transport, resp);
    }

    public <T> T receiveResponse(byte[] bytes, Class<T> returnType) throws IOException, JsonException, RemoteException {
        JsonRpcMessage msg;
        try {
            msg = this.receive(bytes);
        }
        catch (JsonException e) {
            throw new JsonException("parse response error", e);
        }
        if (msg instanceof JsonRpcResponse) {
            return this.fromResponse((JsonRpcResponse)msg, returnType);
        }
        throw new JsonException("invalid response");
    }

    protected JsonRpcResponse execute(JsonRpcRequest request) {
        if (request == null) {
            return new JsonRpcResponse(null, JsonRpcError.parseError());
        }
        String id = request.getId();
        String serviceMethod = request.getMethod();
        ReflectServiceMethodInvoker invoker = this.serviceRegistry.getInvoker(serviceMethod);
        if (invoker == null) {
            return new JsonRpcResponse(id, JsonRpcError.methodNotFoundError());
        }
        JsonNode[] params = request.getParams();
        if (invoker.validateParameters(this.jsonImpl, params)) {
            try {
                Object invokeValue = invoker.invoke();
                if (id == null) {
                    return null;
                }
                return this.toResponse(id, invokeValue);
            }
            catch (Throwable t) {
                if (t instanceof InvocationTargetException) {
                    t = ((InvocationTargetException)t).getTargetException();
                }
                LOG.debug("executing error : " + serviceMethod, t);
                return new JsonRpcResponse(id, JsonRpcError.serverError(2, "Server error", t));
            }
        }
        return new JsonRpcResponse(id, JsonRpcError.invalidParamsError());
    }

    protected <T> T from(JsonNode node, Class<T> classType) {
        return this.jsonImpl.convert(node, classType);
    }

    protected JsonRpcResponse toResponse(String id, Object result) {
        JsonNode node = this.jsonImpl.convert(result);
        return new JsonRpcResponse(id, node);
    }

    protected <T> T fromResponse(JsonRpcResponse resp, Class<T> returnType) throws JsonException, RemoteException {
        if (resp.getError() != null) {
            throw RemoteException.of(this.jsonImpl, resp.getError());
        }
        if (resp.getResult() == null) {
            return null;
        }
        try {
            return this.from(resp.getResult(), returnType);
        }
        catch (Throwable t) {
            throw new JsonException(t.getMessage(), t);
        }
    }

    protected JsonRpcMessage receive(byte[] bytes) throws IOException, JsonException {
        JsonRpcLogger logger = this.jsonRpcLogger;
        return this.receive(bytes, logger);
    }

    protected JsonRpcMessage receive(byte[] bytes, JsonRpcLogger logger) throws IOException, JsonException {
        if (this.binaryWrapper != null) {
            LOG.debug(" - {}", (Object)bytes.length);
            bytes = this.binaryWrapper.read(bytes);
            LOG.debug(" = {}", (Object)bytes.length);
        }
        String json = new String(bytes, "UTF-8");
        if (logger != null) {
            logger.onReceive(json);
        } else {
            LOG.debug(" <<  {}", (Object)json);
        }
        return JsonRpcMessage.of(this.jsonImpl, json);
    }

    protected void transmit(Transport transport, JsonRpcMessage message) throws IOException, JsonException {
        JsonRpcLogger logger = this.jsonRpcLogger;
        this.transmit(transport, message, logger);
    }

    protected void transmit(Transport transport, JsonRpcMessage message, JsonRpcLogger logger) throws IOException, JsonException {
        String json = this.toJson(message);
        if (logger != null) {
            logger.onTransmit(json);
        } else {
            LOG.debug(" >>  {}", (Object)json);
        }
        byte[] bytes = json.getBytes("UTF-8");
        if (this.binaryWrapper != null) {
            LOG.debug(" = {}", (Object)bytes.length);
            bytes = this.binaryWrapper.write(bytes);
            LOG.debug(" - {}", (Object)bytes.length);
        }
        transport.sendBinary(bytes);
    }

    protected String toJson(JsonRpcMessage message) throws JsonException {
        try {
            return message.toJson(this.jsonImpl);
        }
        catch (Exception e) {
            throw new JsonException("serialize error", e);
        }
    }

    protected boolean isCompatible(Class<?>[] types, JsonNode[] params) {
        return ReflectServiceMethodInvoker.isCompatible(this.jsonImpl, types, params);
    }

    protected Object[] getArgs(Class<?>[] types, JsonNode[] params) {
        return ReflectServiceMethodInvoker.getArgs(this.jsonImpl, types, params);
    }
}

