/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.lang.reflect.Method;
import java.util.Set;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonNode;

class ReflectServiceMethodInvoker {
    private final Object instance;
    private final Set<Method> methods;
    private Method method;
    private Object[] args;

    ReflectServiceMethodInvoker(Object instance, Set<Method> methods) {
        this.instance = instance;
        this.methods = methods;
    }

    boolean validateParameters(JsonImplementor jsonImpl, JsonNode[] params) {
        this.args = null;
        this.method = null;
        for (Method m : this.methods) {
            if (!ReflectServiceMethodInvoker.isCompatible(jsonImpl, m.getParameterTypes(), params)) continue;
            this.method = m;
            break;
        }
        if (this.method == null) {
            return false;
        }
        this.args = ReflectServiceMethodInvoker.getArgs(jsonImpl, this.method.getParameterTypes(), params);
        return true;
    }

    Object invoke() throws Exception {
        return this.method.invoke(this.instance, this.args);
    }

    static boolean isCompatible(JsonImplementor jsonImpl, Class<?>[] types, JsonNode[] params) {
        if (types.length != params.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (jsonImpl.isCompatible(params[i], types[i])) continue;
            return false;
        }
        return true;
    }

    static Object[] getArgs(JsonImplementor jsonImpl, Class<?>[] types, JsonNode[] params) {
        if (types.length != params.length) {
            throw new IllegalArgumentException();
        }
        Object[] args = new Object[params.length];
        for (int i = 0; i < types.length; ++i) {
            JsonNode node = params[i];
            args[i] = jsonImpl.convert(node, types[i]);
        }
        return args;
    }
}

