/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import net.apexes.wsonrpc.core.message.JsonRpcError;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.util.JsonRpcErrors;

public class RemoteException
extends Exception {
    private static final long serialVersionUID = 1L;
    private final JsonRpcError error;

    private RemoteException(String message, Throwable cause, JsonRpcError error) {
        super(message, cause);
        this.error = error;
    }

    public JsonRpcError getJsonRpcError() {
        return this.error;
    }

    static RemoteException of(JsonImplementor jsonImpl, JsonRpcError error) {
        String message = RemoteException.formatMessage(error);
        Throwable cause = JsonRpcErrors.fromJson(jsonImpl, error.getData());
        return new RemoteException(message, cause, error);
    }

    private static String formatMessage(JsonRpcError error) {
        StringBuilder str = new StringBuilder();
        if (error.getCode() != null) {
            str.append(error.getCode());
        }
        if (error.getMessage() != null) {
            str.append(" ");
            str.append(error.getMessage());
        }
        return str.toString();
    }
}

