/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import net.apexes.wsonrpc.core.BinaryWrapper;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcLogger;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.support.GsonImplementor;

public class WsonrpcConfigBuilder {
    private JsonImplementor jsonImpl;
    private BinaryWrapper binaryWrapper;
    private WsonrpcLogger wsonrpcLogger;

    public static WsonrpcConfig defaultConfig() {
        return WsonrpcConfigBuilder.create().build();
    }

    public static WsonrpcConfigBuilder create() {
        return new WsonrpcConfigBuilder();
    }

    protected WsonrpcConfigBuilder() {
    }

    public WsonrpcConfig build() {
        if (this.jsonImpl == null) {
            this.jsonImpl = new GsonImplementor();
        }
        return new WsonrpcConfigImpl(this.jsonImpl, this.binaryWrapper, this.wsonrpcLogger);
    }

    public WsonrpcConfigBuilder json(JsonImplementor jsonImpl) {
        this.jsonImpl = jsonImpl;
        return this;
    }

    public WsonrpcConfigBuilder wrapper(BinaryWrapper binaryWrapper) {
        this.binaryWrapper = binaryWrapper;
        return this;
    }

    public WsonrpcConfigBuilder logger(WsonrpcLogger wsonrpcLogger) {
        this.wsonrpcLogger = wsonrpcLogger;
        return this;
    }

    protected static class WsonrpcConfigImpl
    implements WsonrpcConfig {
        private final JsonImplementor jsonImpl;
        private final BinaryWrapper binaryWrapper;
        private final WsonrpcLogger wsonrpcLogger;

        protected WsonrpcConfigImpl(WsonrpcConfig config) {
            this(config.getJsonImplementor(), config.getBinaryWrapper(), config.getWsonrpcLogger());
        }

        protected WsonrpcConfigImpl(JsonImplementor jsonImpl, BinaryWrapper binaryWrapper, WsonrpcLogger wsonrpcLogger) {
            this.jsonImpl = jsonImpl;
            this.binaryWrapper = binaryWrapper;
            this.wsonrpcLogger = wsonrpcLogger;
        }

        @Override
        public JsonImplementor getJsonImplementor() {
            return this.jsonImpl;
        }

        @Override
        public BinaryWrapper getBinaryWrapper() {
            return this.binaryWrapper;
        }

        @Override
        public WsonrpcLogger getWsonrpcLogger() {
            return this.wsonrpcLogger;
        }
    }
}

