/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.message;

import net.apexes.wsonrpc.util.JsonRpcErrors;

public class JsonRpcError {
    private final Integer code;
    private final String message;
    private final String data;

    public JsonRpcError(Integer code, String message, String data) {
        this.code = code;
        this.message = message;
        this.data = data;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getData() {
        return this.data;
    }

    public static JsonRpcError parseError() {
        return JsonRpcError.parseError((Throwable)null);
    }

    public static JsonRpcError parseError(String message) {
        return JsonRpcError.parseError(message, null);
    }

    public static JsonRpcError parseError(Throwable t) {
        return JsonRpcError.parseError("Parse error", t);
    }

    public static JsonRpcError parseError(String message, Throwable t) {
        return new JsonRpcError(-32700, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError invalidRequestError() {
        return JsonRpcError.invalidRequestError((Throwable)null);
    }

    public static JsonRpcError invalidRequestError(String message) {
        return JsonRpcError.invalidRequestError(message, null);
    }

    public static JsonRpcError invalidRequestError(Throwable t) {
        return JsonRpcError.invalidRequestError("Invalid Requestr", t);
    }

    public static JsonRpcError invalidRequestError(String message, Throwable t) {
        return new JsonRpcError(-32600, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError methodNotFoundError() {
        return JsonRpcError.methodNotFoundError((Throwable)null);
    }

    public static JsonRpcError methodNotFoundError(String message) {
        return JsonRpcError.methodNotFoundError(message, null);
    }

    public static JsonRpcError methodNotFoundError(Throwable t) {
        return JsonRpcError.methodNotFoundError("Method not found", t);
    }

    public static JsonRpcError methodNotFoundError(String message, Throwable t) {
        return new JsonRpcError(-32601, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError invalidParamsError() {
        return JsonRpcError.invalidParamsError((Throwable)null);
    }

    public static JsonRpcError invalidParamsError(String message) {
        return JsonRpcError.invalidParamsError(message, null);
    }

    public static JsonRpcError invalidParamsError(Throwable t) {
        return JsonRpcError.invalidParamsError("Invalid params", t);
    }

    public static JsonRpcError invalidParamsError(String message, Throwable t) {
        return new JsonRpcError(-32602, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError internalError() {
        return JsonRpcError.internalError((Throwable)null);
    }

    public static JsonRpcError internalError(String message) {
        return JsonRpcError.internalError(message, null);
    }

    public static JsonRpcError internalError(Throwable t) {
        return JsonRpcError.internalError("Internal error", t);
    }

    public static JsonRpcError internalError(String message, Throwable t) {
        return new JsonRpcError(-32603, message, JsonRpcErrors.toJson(t));
    }

    public static JsonRpcError serverError(int index, String msg, Throwable t) {
        return new JsonRpcError(-32000 - index, msg, JsonRpcErrors.toJson(t));
    }
}

