/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.message;

import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.core.message.JsonRpcError;
import net.apexes.wsonrpc.core.message.JsonRpcRequest;
import net.apexes.wsonrpc.core.message.JsonRpcResponse;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonNode;

public abstract class JsonRpcMessage {
    protected final String id;

    protected JsonRpcMessage(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public abstract String toJson(JsonImplementor var1) throws JsonException;

    public static JsonRpcMessage of(JsonImplementor jsonImpl, String json) throws JsonException {
        JsonNode node = jsonImpl.fromJson(json);
        String id = null;
        if (node.has("id")) {
            id = node.getString("id");
        }
        if (node.has("method")) {
            String method = node.getString("method");
            JsonNode[] params = node.has("params") ? node.getArray("params") : new JsonNode[]{};
            return new JsonRpcRequest(id, method, params);
        }
        if (node.has("error")) {
            JsonNode error = node.get("error");
            Integer code = error.getInteger("code");
            String message = error.getString("message");
            String data = null;
            if (error.has("data")) {
                data = error.getString("data");
            }
            return new JsonRpcResponse(id, new JsonRpcError(code, message, data));
        }
        if (node.has("result")) {
            JsonNode result = node.get("result");
            return new JsonRpcResponse(id, result);
        }
        return null;
    }
}

