/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core.message;

import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.core.message.JsonRpcMessage;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonNode;

public class JsonRpcRequest
extends JsonRpcMessage {
    private final String method;
    private final JsonNode[] params;

    public JsonRpcRequest(String id, String method, JsonNode[] params) {
        super(id);
        if (method == null) {
            throw new NullPointerException("method");
        }
        this.method = method;
        this.params = params == null ? new JsonNode[0] : params;
    }

    public String getMethod() {
        return this.method;
    }

    public JsonNode[] getParams() {
        return this.params;
    }

    public boolean isNotice() {
        return this.id == null;
    }

    @Override
    public String toJson(JsonImplementor jsonImpl) throws JsonException {
        JsonNode req = jsonImpl.createNode();
        req.put("jsonrpc", "2.0");
        if (this.id != null) {
            req.put("id", this.id);
        }
        req.put("method", this.method);
        if (this.params != null && this.params.length > 0) {
            req.put("params", this.params);
        }
        return jsonImpl.toJson(req);
    }
}

