/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.json.support;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import net.apexes.wsonrpc.core.JsonException;
import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonNode;

public class JacksonImplementor
implements JsonImplementor {
    private final ObjectMapper objectMapper;

    public JacksonImplementor() {
        this(new ObjectMapper());
    }

    public JacksonImplementor(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public JsonNode fromJson(String json) throws JsonException {
        try {
            return new JacksonJsonNode(this.objectMapper.readTree(json));
        }
        catch (IOException e) {
            throw new JsonException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String toJson(JsonNode node) throws JsonException {
        JacksonJsonNode jacksonNode = (JacksonJsonNode)node;
        try {
            return this.objectMapper.writeValueAsString((Object)jacksonNode.jsonNode);
        }
        catch (JsonProcessingException e) {
            throw new JsonException(e.getMessage(), e.getCause());
        }
    }

    @Override
    public String toJson(List<JsonNode> nodeList) throws JsonException {
        ArrayNode array = this.objectMapper.createArrayNode();
        for (JsonNode node : nodeList) {
            JacksonJsonNode jacksonNode = (JacksonJsonNode)node;
            array.add(jacksonNode.jsonNode);
        }
        return array.toString();
    }

    @Override
    public JsonNode createNode() {
        JsonNodeFactory factory = new JsonNodeFactory(false);
        return new JacksonJsonNode((com.fasterxml.jackson.databind.JsonNode)factory.objectNode());
    }

    @Override
    public boolean isCompatible(JsonNode node, Class<?> classType) {
        return true;
    }

    @Override
    public <T> T convert(JsonNode node, Class<T> classType) {
        JacksonJsonNode jacksonNode = (JacksonJsonNode)node;
        return (T)this.objectMapper.convertValue((Object)jacksonNode.jsonNode, classType);
    }

    @Override
    public JsonNode convert(Object object) {
        return new JacksonJsonNode(this.objectMapper.valueToTree(object));
    }

    private static class JacksonJsonNode
    implements JsonNode {
        private final com.fasterxml.jackson.databind.JsonNode jsonNode;

        public JacksonJsonNode(com.fasterxml.jackson.databind.JsonNode jsonNode) {
            this.jsonNode = jsonNode;
        }

        @Override
        public boolean has(String name) {
            return this.jsonNode.has(name);
        }

        @Override
        public JsonNode get(String name) {
            return new JacksonJsonNode(this.jsonNode.get(name));
        }

        @Override
        public Integer getInteger(String name) {
            com.fasterxml.jackson.databind.JsonNode jn = this.jsonNode.get(name);
            if (jn.isNull()) {
                return null;
            }
            return jn.asInt();
        }

        @Override
        public String getString(String name) {
            com.fasterxml.jackson.databind.JsonNode jn = this.jsonNode.get(name);
            if (jn.isNull()) {
                return null;
            }
            return jn.asText();
        }

        @Override
        public JsonNode[] getArray(String name) {
            com.fasterxml.jackson.databind.JsonNode paramNode = this.jsonNode.get(name);
            int size = paramNode.size();
            JsonNode[] results = new JsonNode[size];
            for (int i = 0; i < size; ++i) {
                results[i] = new JacksonJsonNode(paramNode.get(i));
            }
            return results;
        }

        @Override
        public void put(String name, int value) {
            if (!(this.jsonNode instanceof ObjectNode)) {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            ObjectNode objectNode = (ObjectNode)this.jsonNode;
            objectNode.put(name, value);
        }

        @Override
        public void put(String name, String value) {
            if (!(this.jsonNode instanceof ObjectNode)) {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            ObjectNode objectNode = (ObjectNode)this.jsonNode;
            objectNode.put(name, value);
        }

        @Override
        public void put(String name, JsonNode value) {
            ObjectNode objectNode;
            if (this.jsonNode instanceof ObjectNode) {
                objectNode = (ObjectNode)this.jsonNode;
                if (!(value instanceof JacksonJsonNode)) {
                    throw new UnsupportedOperationException("value must be JacksonNode");
                }
            } else {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            JacksonJsonNode jacksonNode = (JacksonJsonNode)value;
            objectNode.set(name, jacksonNode.jsonNode);
        }

        @Override
        public void put(String name, JsonNode[] array) {
            ArrayNode arrayNode;
            ObjectNode objectNode;
            if (this.jsonNode instanceof ObjectNode) {
                objectNode = (ObjectNode)this.jsonNode;
                arrayNode = objectNode.arrayNode();
                for (int i = 0; i < array.length; ++i) {
                    if (!(array[i] instanceof JacksonJsonNode)) {
                        throw new UnsupportedOperationException("array[" + i + "] must be JacksonNode");
                    }
                    JacksonJsonNode jacksonNode = (JacksonJsonNode)array[i];
                    arrayNode.add(jacksonNode.jsonNode);
                }
            } else {
                throw new UnsupportedOperationException(this.jsonNode.getClass().getName());
            }
            objectNode.set(name, (com.fasterxml.jackson.databind.JsonNode)arrayNode);
        }

        @Override
        public String toJson() {
            return this.jsonNode.toString();
        }

        public String toString() {
            return this.toJson();
        }
    }
}

