/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.util;

import net.apexes.wsonrpc.json.JsonImplementor;
import net.apexes.wsonrpc.json.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpcErrors {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRpcErrors.class);

    private JsonRpcErrors() {
    }

    public static String toJson(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        LOG.debug("throwable to json", throwable);
        StringBuilder sb = new StringBuilder();
        JsonRpcErrors.toJson(sb, throwable);
        return sb.toString();
    }

    private static void toJson(StringBuilder sb, Throwable throwable) {
        StackTraceElement[] arr;
        sb.append("{");
        sb.append("\"errorClass\":\"").append(throwable.getClass().getName()).append("\",");
        if (throwable.getMessage() != null) {
            sb.append("\"errorMessage\":\"").append(throwable.getMessage()).append("\",");
        }
        sb.append("\"stackTrace\":[");
        for (StackTraceElement element : arr = throwable.getStackTrace()) {
            sb.append("{");
            sb.append("\"className\":\"").append(element.getClassName()).append("\",");
            sb.append("\"methodName\":\"").append(element.getMethodName()).append("\",");
            sb.append("\"fileName\":\"").append(element.getFileName()).append("\",");
            sb.append("\"lineNumber\":").append(element.getLineNumber());
            sb.append("},");
        }
        if (throwable.getCause() != null) {
            StringBuilder causeSb = new StringBuilder();
            JsonRpcErrors.toJson(causeSb, throwable.getCause());
            sb.append("\"cause\":").append(causeSb.toString()).append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("]}");
    }

    public static Throwable fromJson(JsonImplementor jsonImpl, String json) {
        LOG.debug("json : {}", (Object)json);
        if (json != null && json.startsWith("{\"errorClass\":")) {
            try {
                JsonNode errorNode = jsonImpl.fromJson(json);
                Throwable cause = JsonRpcErrors.toThrowable(jsonImpl, errorNode);
                return cause;
            }
            catch (Exception e) {
                LOG.debug("json to throwable error.", (Throwable)e);
            }
        }
        return null;
    }

    private static Throwable toThrowable(JsonImplementor jsonImpl, JsonNode errorNode) {
        String message = errorNode.getString("errorClass");
        if (errorNode.has("errorMessage")) {
            message = message + ": " + errorNode.getString("errorMessage");
        }
        JsonNode[] nodeArray = errorNode.getArray("stackTrace");
        StackTraceElement[] stackTrace = new StackTraceElement[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            String className = nodeArray[i].getString("className");
            String methodName = nodeArray[i].getString("methodName");
            String fileName = nodeArray[i].getString("fileName");
            int lineNumber = nodeArray[i].getInteger("lineNumber");
            stackTrace[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
        }
        Throwable cause = null;
        if (errorNode.has("cause")) {
            JsonNode causeNode = errorNode.get("cause");
            cause = JsonRpcErrors.toThrowable(jsonImpl, causeNode);
        }
        RuntimeException throwable = new RuntimeException(message, cause);
        throwable.setStackTrace(stackTrace);
        return throwable;
    }
}

