/*
 * Copyright (C) 2015, apexes.net. All rights reserved.
 * 
 *        http://www.apexes.net
 * 
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.util.concurrent.Future;

/**
 * 
 * @author <a href=mailto:hedyn@foxmail.com>HeDYn</a>
 *
 */
public interface WsonrpcRemote extends Remote {

    String getSessionId();
    
    boolean isConnected();

    void disconnect();
    
    void ping() throws Exception;

    /**
     * 调用远程的方法，返回Future。
     *
     * @param serviceName
     * @param methodName
     * @param args
     * @param returnType
     * @return
     * @throws IOException
     * @throws WsonrpcException
     */
    <T> Future<T> request(String serviceName, String methodName, Object[] args, Class<T> returnType)
            throws IOException, WsonrpcException;

    /**
     * 调用远端方法。
     *
     * @param serviceName
     * @param methodName
     * @param args
     * @param callback
     * @throws IOException
     * @throws WsonrpcException
     */
    void request(String serviceName, String methodName, Object[] args, WsonrpcCallback callback)
            throws IOException, WsonrpcException;

}
