/*
 * Copyright (C) 2016, apexes.net. All rights reserved.
 * 
 *        http://www.apexes.net
 * 
 */
package net.apexes.wsonrpc.json;

import net.apexes.wsonrpc.core.JsonException;

/**
 * 
 * @author <a href="mailto:hedyn@foxmail.com">HeDYn</a>
 *
 */
public interface JsonImplementor {

    JsonRpcMessage fromJson(String json) throws JsonException;

    JsonRpcRequest createRequest(String id, String method, Object[] params);

    JsonRpcResponse createResponse(String id, Object result);

    JsonRpcResponse createResponse(JsonRpcError error);

    JsonRpcResponse createResponse(String id, JsonRpcError error);

//    /**
//     * 将JSON格式文本反序列化为{@link JsonNode}对象
//     *
//     * @param json JSON格式文本
//     * @return 返回{@link Node}对象
//     * @throws JsonException
//     */
//    JsonNode fromJson(String json) throws JsonException;
//
//    /**
//     * 将{@link JsonNode}对象序列化为JSON格式文本
//     *
//     * @param node {@link JsonNode}对象
//     * @return 返回序列化后的JSON格式文本
//     * @throws JsonException
//     */
//    String toJson(JsonNode node) throws JsonException;
//
//    /**
//     * 将{@link JsonNode}对象列表序列化为JSON格式文本
//     * @param nodeList {@link JsonNode}对象列表
//     * @return 返回序列化后的JSON格式文本
//     * @throws JsonException
//     */
//    String toJson(List<JsonNode> nodeList) throws JsonException;
//
//    /**
//     * 创建一个{@link JsonNode}对象
//     *
//     * @return 返回创建一个{@link Node}对象
//     */
//    JsonNode createNode();
//
//    /**
//     * 判断{@link JsonNode}型数组是否匹配指定方法的参数
//     * @param method 方法
//     * @param params {@link JsonNode}型参数数组
//     * @return 如果匹配返回true，否则返回false
//     */
//    boolean isCompatible(Method method, JsonNode[] params);
//
//    /**
//     * 将{@link JsonNode}型数组转为适合指定方法调用的参数对象数组
//     * @param method 方法
//     * @param params {@link JsonNode}型参数数组
//     * @return 返回适合指定方法调用的参数对象数组
//     */
//    Object[] convert(Method method, JsonNode[] params);
//
//    /**
//     * 将{@link JsonNode}对象转为指定类型的对象
//     *
//     * @param node {@link JsonNode}对象
//     * @param classType 类型
//     * @return 返回指定类型的对象
//     */
//    <T> T convert(JsonNode node, Class<T> classType);
//
//    /**
//     * 将指定类型的对象转为{@link JsonNode}对象
//     *
//     * @param object 指定类型的对象
//     * @return 返回{@link Node}对象
//     */
//    JsonNode convert(Object object);

}
