/*
 * Decompiled with CFR 0.152.
 */
package net.apexes.wsonrpc.core;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.apexes.wsonrpc.core.RemoteException;
import net.apexes.wsonrpc.core.WebSocketSession;
import net.apexes.wsonrpc.core.WsonrpcCallback;
import net.apexes.wsonrpc.core.WsonrpcConfig;
import net.apexes.wsonrpc.core.WsonrpcEngine;
import net.apexes.wsonrpc.core.WsonrpcException;
import net.apexes.wsonrpc.core.WsonrpcRemote;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsonrpcEndpoint
implements WsonrpcRemote {
    private static final Logger LOG = LoggerFactory.getLogger(WsonrpcEndpoint.class);
    protected final WsonrpcEngine wsonrpcEngine;
    private WebSocketSession session;

    protected WsonrpcEndpoint(WsonrpcConfig config) {
        this(new WsonrpcEngine(config));
    }

    protected WsonrpcEndpoint(WsonrpcEngine wsonrpcEngine) {
        this.wsonrpcEngine = wsonrpcEngine;
    }

    protected final void openSession(WebSocketSession session) {
        this.session = session;
    }

    protected void closeSession() throws Exception {
        if (this.session != null) {
            this.session.close();
            this.session = null;
        }
    }

    protected WebSocketSession getSession() {
        return this.session;
    }

    protected void verifyOnline() throws WsonrpcException {
        if (!this.isConnected()) {
            throw new WsonrpcException("Connection is closed.");
        }
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    @Override
    public String getSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    @Override
    public void disconnect() {
        try {
            this.closeSession();
        }
        catch (Exception e) {
            LOG.warn("disconnect error!");
        }
    }

    @Override
    public void ping() throws Exception {
        this.verifyOnline();
        this.session.ping();
    }

    @Override
    public void notify(String serviceName, String methodName, Object[] args) throws IOException, WsonrpcException {
        this.verifyOnline();
        this.wsonrpcEngine.notify(this.getSession(), serviceName, methodName, args);
    }

    @Override
    public <T> T request(String serviceName, String methodName, Object[] args, Class<T> returnType, int timeout) throws IOException, WsonrpcException, RemoteException {
        Future<T> future = this.request(serviceName, methodName, args, returnType);
        try {
            if (timeout <= 0) {
                return future.get();
            }
            return future.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            if (e instanceof ExecutionException) {
                e = e.getCause();
            }
            if (e instanceof RemoteException) {
                throw (RemoteException)e;
            }
            if (e instanceof WsonrpcException) {
                throw (WsonrpcException)e;
            }
            throw new WsonrpcException(e);
        }
    }

    @Override
    public <T> Future<T> request(String serviceName, String methodName, Object[] args, Class<T> returnType) throws IOException, WsonrpcException {
        this.verifyOnline();
        return this.wsonrpcEngine.request(this.session, serviceName, methodName, args, returnType);
    }

    @Override
    public void request(String serviceName, String methodName, Object[] args, WsonrpcCallback callback) throws IOException, WsonrpcException {
        this.wsonrpcEngine.request(this.session, serviceName, methodName, args, callback);
    }
}

